/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.util;

import java.io.File;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.fixme.Strings;
import lombok.NonNull;
import nbbrd.io.text.BooleanProperty;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import nbbrd.io.text.Property;
import org.jspecify.annotations.Nullable;

public interface PropertyHandler<P> {
    @NonNull
    default public P getDefaultValue() {
        return this.get(ignored -> null);
    }

    @NonNull
    public P get(@NonNull Function<? super String, ? extends CharSequence> var1);

    public void set(@NonNull BiConsumer<? super String, ? super String> var1, @Nullable P var2);

    default public @NonNull DataSource.Converter<P> asDataSourceConverter() {
        return new DataSource.Converter<P>(){

            @Override
            @NonNull
            public P getDefaultValue() {
                return PropertyHandler.this.getDefaultValue();
            }

            @Override
            @NonNull
            public P get(@NonNull DataSource config) {
                if (config == null) {
                    throw new NullPointerException("config is marked non-null but is null");
                }
                return PropertyHandler.this.get(config::getParameter);
            }

            @Override
            public void set(@NonNull DataSource.Builder builder, @Nullable P value) {
                if (builder == null) {
                    throw new NullPointerException("builder is marked non-null but is null");
                }
                PropertyHandler.this.set(builder::parameter, value);
            }
        };
    }

    default public @NonNull DataSet.Converter<P> asDataSetConverter() {
        return new DataSet.Converter<P>(){

            @Override
            @NonNull
            public P getDefaultValue() {
                return PropertyHandler.this.getDefaultValue();
            }

            @Override
            @NonNull
            public P get(@NonNull DataSet config) {
                if (config == null) {
                    throw new NullPointerException("config is marked non-null but is null");
                }
                return PropertyHandler.this.get(config::getParameter);
            }

            @Override
            public void set(@NonNull DataSet.Builder builder, @Nullable P value) {
                if (builder == null) {
                    throw new NullPointerException("builder is marked non-null but is null");
                }
                PropertyHandler.this.set(builder::parameter, value);
            }
        };
    }

    @NonNull
    public static PropertyHandler<Boolean> onBoolean(String key, boolean defaultValue) {
        final BooleanProperty delegate = BooleanProperty.of((String)key, (boolean)defaultValue);
        return new PropertyHandler<Boolean>(){

            @Override
            @NonNull
            public Boolean getDefaultValue() {
                return delegate.isDefaultValue();
            }

            @Override
            @NonNull
            public Boolean get(@NonNull Function<? super String, ? extends CharSequence> properties) {
                if (properties == null) {
                    throw new NullPointerException("properties is marked non-null but is null");
                }
                return delegate.get(properties);
            }

            @Override
            public void set(@NonNull BiConsumer<? super String, ? super String> properties, @Nullable Boolean value) {
                if (properties == null) {
                    throw new NullPointerException("properties is marked non-null but is null");
                }
                if (value != null) {
                    delegate.set(properties, value.booleanValue());
                }
            }
        };
    }

    public static PropertyHandler<Long> onLong(String key, long defaultValue) {
        return PropertyHandler.of(Property.of((String)key, (Object)defaultValue, (Parser)Parser.onLong(), (Formatter)Formatter.onLong()));
    }

    public static PropertyHandler<Integer> onInteger(String key, int defaultValue) {
        return PropertyHandler.of(Property.of((String)key, (Object)defaultValue, (Parser)Parser.onInteger(), (Formatter)Formatter.onInteger()));
    }

    @NonNull
    public static <T extends Enum<T>> PropertyHandler<T> onEnum(String key, T defaultValue) {
        return PropertyHandler.of(Property.of((String)key, defaultValue, (Parser)Parser.onEnum(defaultValue.getClass()), (Formatter)Formatter.onEnum()));
    }

    @NonNull
    public static PropertyHandler<String> onString(String key, String defaultValue) {
        return PropertyHandler.of(Property.of((String)key, (Object)defaultValue, (Parser)Parser.onString(), (Formatter)Formatter.onString()));
    }

    @NonNull
    public static PropertyHandler<File> onFile(String key, File defaultValue) {
        return PropertyHandler.of(Property.of((String)key, (Object)defaultValue, (Parser)Parser.onFile(), (Formatter)Formatter.onFile()));
    }

    @NonNull
    public static PropertyHandler<Locale> onLocale(String key, Locale defaultValue) {
        return PropertyHandler.of(Property.of((String)key, (Object)defaultValue, (Parser)Parser.onLocale(), (Formatter)Formatter.of(Locale::toString)));
    }

    public static PropertyHandler<List<String>> onStringList(String key, List<String> defaultValue, char separator) {
        Function<CharSequence, Stream> splitter = o -> Strings.splitToStream(separator, o).map(String::trim).filter(Strings::isNotEmpty);
        Function<Stream, String> joiner = o -> o.collect(Collectors.joining(String.valueOf(separator)));
        return PropertyHandler.of(Property.of((String)key, defaultValue, (Parser)Parser.onStringList(splitter), (Formatter)Formatter.onStringList(joiner)));
    }

    public static PropertyHandler<Duration> onDurationInMillis(String key, Duration defaultValue) {
        return PropertyHandler.of(Property.of((String)key, (Object)defaultValue, (Parser)Parser.onLong().andThen(Duration::ofMillis), (Formatter)Formatter.onLong().compose(Duration::toMillis)));
    }

    public static PropertyHandler<Charset> onCharset(String key, Charset defaultValue) {
        return PropertyHandler.of(Property.of((String)key, (Object)defaultValue, (Parser)Parser.onCharset(), (Formatter)Formatter.onCharset()));
    }

    @NonNull
    public static <T> PropertyHandler<T> of(String key, T defaultValue, Function<? super CharSequence, T> parser, Function<T, ? extends CharSequence> formatter) {
        return PropertyHandler.of(Property.of((String)key, defaultValue, (Parser)Parser.of(parser), (Formatter)Formatter.of(formatter)));
    }

    @Deprecated
    @NonNull
    public static <T> PropertyHandler<T> of(final Property<T> delegate) {
        return new PropertyHandler<T>(){

            @Override
            @NonNull
            public T getDefaultValue() {
                return delegate.getDefaultValue();
            }

            @Override
            @NonNull
            public T get(@NonNull Function<? super String, ? extends CharSequence> properties) {
                if (properties == null) {
                    throw new NullPointerException("properties is marked non-null but is null");
                }
                return delegate.get(properties);
            }

            @Override
            public void set(@NonNull BiConsumer<? super String, ? super String> properties, @Nullable T value) {
                if (properties == null) {
                    throw new NullPointerException("properties is marked non-null but is null");
                }
                delegate.set(properties, value);
            }
        };
    }

    default public PropertyHandler<P> withPrefix(final String prefix) {
        final PropertyHandler delegate = this;
        return new PropertyHandler<P>(){

            @Override
            @NonNull
            public P getDefaultValue() {
                return delegate.getDefaultValue();
            }

            @Override
            @NonNull
            public P get(@NonNull Function<? super String, ? extends CharSequence> properties) {
                if (properties == null) {
                    throw new NullPointerException("properties is marked non-null but is null");
                }
                return delegate.get(key -> (CharSequence)properties.apply(prefix + key));
            }

            @Override
            public void set(@NonNull BiConsumer<? super String, ? super String> properties, @Nullable P value) {
                if (properties == null) {
                    throw new NullPointerException("properties is marked non-null but is null");
                }
                delegate.set((key, text) -> properties.accept(prefix + key, (String)text), value);
            }
        };
    }
}

