/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.DiscreteDistribution;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.core.stats.Combinatorics;

public class Poisson
implements DiscreteDistribution {
    private final double mu;
    private final double emu;

    public Poisson(double mu) {
        this.mu = mu;
        this.emu = Math.exp(-mu);
    }

    public long getLeftBound() {
        return 0L;
    }

    public long getRightBound() {
        return Long.MAX_VALUE;
    }

    public String getDescription() {
        return "Poisson - " + Double.toString(this.mu);
    }

    public double getExpectation() throws DStatException {
        return this.mu;
    }

    public double getProbability(long x) throws DStatException {
        double lf = Combinatorics.logFactorial(x);
        double p = Math.exp(Math.log(this.mu) * (double)x - lf - this.mu);
        return p;
    }

    public double getVariance() throws DStatException {
        return this.mu;
    }

    public BoundaryType hasLeftBound() {
        return BoundaryType.Finite;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    public boolean isSymmetrical() {
        return false;
    }

    public long random(RandomNumberGenerator rng) throws DStatException {
        int rndPoisson = -1;
        double p = 1.0;
        do {
            ++rndPoisson;
        } while ((p *= rng.nextDouble()) > this.emu);
        return rndPoisson;
    }
}

