/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.benchmarking;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import lombok.Generated;

public final class SsfCumulator {
    public static StateComponent of(StateComponent s, ISsfLoading loading, int conversion, int start) {
        if (conversion == 0) {
            return new StateComponent(new Initialization(s.initialization()), new CDynamics(s.dynamics(), loading));
        }
        return new StateComponent(new Initialization(s.initialization()), new Dynamics(s.dynamics(), loading, conversion, start));
    }

    public static ISsfLoading defaultLoading(ISsfLoading l, int conversion, int start) {
        if (conversion == 0) {
            return new CLoading(l);
        }
        return new Loading(l, conversion, start);
    }

    @Generated
    private SsfCumulator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Initialization
    implements ISsfInitialization {
        private final ISsfInitialization initialization;

        Initialization(ISsfInitialization initialization) {
            this.initialization = initialization;
        }

        @Override
        public int getStateDim() {
            return this.initialization.getStateDim() + 1;
        }

        @Override
        public boolean isDiffuse() {
            return this.initialization.isDiffuse();
        }

        @Override
        public int getDiffuseDim() {
            return this.initialization.getDiffuseDim();
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            this.initialization.diffuseConstraints(b.dropTopLeft(1, 0));
        }

        @Override
        public void a0(DataBlock a0) {
            this.initialization.a0(a0.drop(1, 0));
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            this.initialization.Pf0(pf0.dropTopLeft(1, 1));
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            this.initialization.Pi0(pi0.dropTopLeft(1, 1));
        }
    }

    static class CDynamics
    implements ISsfDynamics {
        private final ISsfDynamics dynamics;
        private final ISsfLoading loading;

        CDynamics(ISsfDynamics dynamics, ISsfLoading loading) {
            this.dynamics = dynamics;
            this.loading = loading;
        }

        @Override
        public int getInnovationsDim() {
            return this.dynamics.getInnovationsDim();
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return this.dynamics.areInnovationsTimeInvariant();
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            this.dynamics.V(pos, qm.dropTopLeft(1, 1));
        }

        @Override
        public void S(int pos, FastMatrix s) {
            this.dynamics.S(pos, s.dropTopLeft(1, 0));
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.dynamics.hasInnovations(pos);
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            this.dynamics.T(pos, tr.dropTopLeft(1, 1));
            this.loading.Z(pos, tr.row(0).drop(1, 0));
            tr.set(0, 0, 1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            DataBlock xc = x.drop(1, 0);
            double s = this.loading.ZX(pos, xc);
            x.add(0, s);
            this.dynamics.TX(pos, xc);
        }

        @Override
        public void TVT(int pos, FastMatrix vm) {
            FastMatrix v = vm.dropTopLeft(1, 1);
            DataBlock r0 = vm.row(0).drop(1, 0);
            double zv0 = this.loading.ZX(pos, r0);
            this.loading.ZM(pos, v, r0);
            vm.add(0, 0, 2.0 * zv0 + this.loading.ZX(pos, r0));
            this.dynamics.TX(pos, r0);
            DataBlock c0 = vm.column(0).drop(1, 0);
            this.dynamics.TX(pos, c0);
            c0.add(r0);
            r0.copy(c0);
            this.dynamics.TVT(pos, v);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            this.dynamics.addSU(pos, x.drop(1, 0), u);
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            this.dynamics.addV(pos, p.dropTopLeft(1, 1));
        }

        @Override
        public void XT(int pos, DataBlock x) {
            DataBlock xc = x.drop(1, 0);
            this.dynamics.XT(pos, xc);
            this.loading.XpZd(pos, xc, x.get(0));
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            this.dynamics.XS(pos, x.drop(1, 0), xs);
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final ISsfDynamics dynamics;
        private final ISsfLoading loading;
        private final int conversion;
        private final int start;

        Dynamics(ISsfDynamics dynamics, ISsfLoading loading, int conversion) {
            this.dynamics = dynamics;
            this.loading = loading;
            this.conversion = conversion;
            this.start = 0;
        }

        Dynamics(ISsfDynamics dynamics, ISsfLoading loading, int conversion, int start) {
            this.dynamics = dynamics;
            this.loading = loading;
            this.conversion = conversion;
            this.start = start;
        }

        @Override
        public int getInnovationsDim() {
            return this.dynamics.getInnovationsDim();
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return this.dynamics.areInnovationsTimeInvariant();
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            this.dynamics.V(pos, qm.dropTopLeft(1, 1));
        }

        @Override
        public void S(int pos, FastMatrix s) {
            this.dynamics.S(pos, s.dropTopLeft(1, 0));
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.dynamics.hasInnovations(pos);
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            this.dynamics.T(pos, tr.dropTopLeft(1, 1));
            if ((this.start + pos + 1) % this.conversion != 0) {
                this.loading.Z(pos, tr.row(0).drop(1, 0));
                if ((this.start + pos) % this.conversion != 0) {
                    tr.set(0, 0, 1.0);
                }
            }
        }

        @Override
        public void TX(int pos, DataBlock x) {
            DataBlock xc = x.drop(1, 0);
            if ((this.start + pos + 1) % this.conversion != 0) {
                double s = this.loading.ZX(pos, xc);
                if ((this.start + pos) % this.conversion == 0) {
                    x.set(0, s);
                } else {
                    x.add(0, s);
                }
            } else {
                x.set(0, 0.0);
            }
            this.dynamics.TX(pos, xc);
        }

        @Override
        public void TVT(int pos, FastMatrix vm) {
            FastMatrix v = vm.dropTopLeft(1, 1);
            if ((this.start + pos) % this.conversion == 0) {
                DataBlock v0 = vm.row(0).drop(1, 0);
                this.loading.ZM(pos, v, v0);
                vm.set(0, 0, this.loading.ZX(pos, v0));
                this.dynamics.TX(pos, v0);
                vm.column(0).drop(1, 0).copy(v0);
            } else if ((this.start + pos + 1) % this.conversion != 0) {
                DataBlock r0 = vm.row(0).drop(1, 0);
                double zv0 = this.loading.ZX(pos, r0);
                this.loading.ZM(pos, v, r0);
                vm.add(0, 0, 2.0 * zv0 + this.loading.ZX(pos, r0));
                this.dynamics.TX(pos, r0);
                DataBlock c0 = vm.column(0).drop(1, 0);
                this.dynamics.TX(pos, c0);
                c0.add(r0);
                r0.copy(c0);
            } else {
                vm.row(0).set(0.0);
                vm.column(0).set(0.0);
            }
            this.dynamics.TVT(pos, v);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            this.dynamics.addSU(pos, x.drop(1, 0), u);
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            this.dynamics.addV(pos, p.dropTopLeft(1, 1));
        }

        @Override
        public void XT(int pos, DataBlock x) {
            DataBlock xc = x.drop(1, 0);
            this.dynamics.XT(pos, xc);
            if ((this.start + pos + 1) % this.conversion != 0) {
                this.loading.XpZd(pos, xc, x.get(0));
                if ((this.start + pos) % this.conversion == 0) {
                    x.set(0, 0.0);
                }
            } else {
                x.set(0, 0.0);
            }
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            this.dynamics.XS(pos, x.drop(1, 0), xs);
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }
    }

    static class CLoading
    implements ISsfLoading {
        private final ISsfLoading loading;

        CLoading(ISsfLoading loading) {
            this.loading = loading;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            z.set(0, 1.0);
            this.loading.Z(pos, z.drop(1, 0));
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            return x.get(0) + this.loading.ZX(pos, x.drop(1, 0));
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            zm.copy(m.row(0));
            FastMatrix q = m.dropTopLeft(1, 0);
            DataBlockIterator cols = q.columnsIterator();
            DoubleSeqCursor.OnMutable cur = zm.cursor();
            while (cols.hasNext()) {
                cur.applyAndNext(x -> x + this.loading.ZX(pos, cols.next()));
            }
        }

        @Override
        public double ZVZ(int pos, FastMatrix vm) {
            FastMatrix v = vm.dropTopLeft(1, 1);
            double r = vm.get(0, 0);
            r += 2.0 * this.loading.ZX(pos, vm.row(0).drop(1, 0));
            return r += this.loading.ZVZ(pos, v);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix vm, double d) {
            if (d == 0.0) {
                return;
            }
            FastMatrix v = vm.dropTopLeft(1, 1);
            this.loading.VpZdZ(pos, v, d);
            vm.add(0, 0, d);
            this.loading.XpZd(pos, vm.column(0).drop(1, 0), d);
            this.loading.XpZd(pos, vm.row(0).drop(1, 0), d);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            this.loading.XpZd(pos, x.drop(1, 0), d);
            x.add(0, d);
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }
    }

    static class Loading
    implements ISsfLoading {
        private final ISsfLoading loading;
        private final int conversion;
        private final int start;

        Loading(ISsfLoading loading, int conversion) {
            this.loading = loading;
            this.conversion = conversion;
            this.start = 0;
        }

        Loading(ISsfLoading loading, int conversion, int start) {
            this.loading = loading;
            this.conversion = conversion;
            this.start = start;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            if ((this.start + pos) % this.conversion != 0) {
                z.set(0, 1.0);
            }
            this.loading.Z(pos, z.drop(1, 0));
        }

        @Override
        public double ZX(int pos, DataBlock x) {
            double r = (this.start + pos) % this.conversion == 0 ? 0.0 : x.get(0);
            return r + this.loading.ZX(pos, x.drop(1, 0));
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            if ((this.start + pos) % this.conversion == 0) {
                zm.set(0.0);
            } else {
                zm.copy(m.row(0));
            }
            FastMatrix q = m.dropTopLeft(1, 0);
            DataBlockIterator cols = q.columnsIterator();
            DoubleSeqCursor.OnMutable cur = zm.cursor();
            while (cols.hasNext()) {
                cur.applyAndNext(x -> x + this.loading.ZX(pos, cols.next()));
            }
        }

        @Override
        public double ZVZ(int pos, FastMatrix vm) {
            FastMatrix v = vm.dropTopLeft(1, 1);
            if ((this.start + pos) % this.conversion == 0) {
                return this.loading.ZVZ(pos, v);
            }
            double r = vm.get(0, 0);
            r += 2.0 * this.loading.ZX(pos, vm.row(0).drop(1, 0));
            return r += this.loading.ZVZ(pos, v);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix vm, double d) {
            if (d == 0.0) {
                return;
            }
            FastMatrix v = vm.dropTopLeft(1, 1);
            this.loading.VpZdZ(pos, v, d);
            if ((this.start + pos) % this.conversion != 0) {
                vm.add(0, 0, d);
                this.loading.XpZd(pos, vm.column(0).drop(1, 0), d);
                this.loading.XpZd(pos, vm.row(0).drop(1, 0), d);
            }
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            this.loading.XpZd(pos, x.drop(1, 0), d);
            if ((this.start + pos) % this.conversion != 0) {
                x.add(0, d);
            }
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }
    }
}

