/*
 * Decompiled with CFR 0.152.
 */
package ObjectiveFunctions;

import ObjectiveFunctions.ObjectiveFunction;

public class KernelObjective
extends ObjectiveFunction {
    private double[][] Kgram;
    protected int[] w;
    private int n;
    protected Double running_kernel_sum;
    private Integer t;
    private Integer c;
    private double initial_obj_val;

    public KernelObjective(double[][] dArray) {
        this.Kgram = dArray;
        this.n = dArray.length;
    }

    @Override
    public double calc(boolean bl) {
        if (this.running_kernel_sum == null) {
            this.fullQuadraticFormCalculationAndCache(bl);
            if (this.t == null) {
                return this.running_kernel_sum;
            }
        }
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            if (i == this.t || i == this.c) continue;
            d += (double)this.w[i] * (this.Kgram[this.t][i] - this.Kgram[this.c][i]);
        }
        return this.running_kernel_sum - 4.0 * d;
    }

    public void resetKernelSum() {
        this.running_kernel_sum = null;
    }

    private void fullQuadraticFormCalculationAndCache(boolean bl) {
        this.t = null;
        this.c = null;
        this.running_kernel_sum = 0.0;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.running_kernel_sum = this.running_kernel_sum + this.Kgram[i][j] * (double)this.w[i] * (double)this.w[j];
            }
        }
        if (bl) {
            System.out.println("kernel_sum: " + this.running_kernel_sum);
        }
    }

    public void setSwitch(int n, int n2) {
        this.t = n;
        this.c = n2;
    }

    public void setW(int[] nArray) {
        int n = nArray.length;
        this.w = new int[n];
        for (int i = 0; i < n; ++i) {
            this.w[i] = nArray[i] == 1 ? 1 : -1;
        }
    }

    public double log10_i_over_current_obj_val() {
        double d = this.calc(false);
        return Math.log10(this.initial_obj_val / d);
    }

    public void setInitialObjVal() {
        this.initial_obj_val = this.calc(false);
    }
}

