## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----eval = FALSE-------------------------------------------------------------
# library(misha)
# gdb.init_examples()

## ----eval = FALSE-------------------------------------------------------------
# gtrack.ls() # list tracks in the examples DB
# gtrack.info("dense_track") # inspect type/metadata
# gtrack.info("sparse_track")

## ----eval = FALSE-------------------------------------------------------------
# regions <- gintervals(1, c(0, 250000), c(100000, 260000))

## ----eval = FALSE-------------------------------------------------------------
# out <- gextract("dense_track", regions, iterator = 100)
# log_out <- gextract("log(dense_track + 1)", regions, iterator = 100)

## ----eval = FALSE-------------------------------------------------------------
# gintervals.save(regions, "my_intervals_set")
# out2 <- gextract("dense_track", gintervals.all(), iterator = "my_intervals_set")

## ----eval = FALSE-------------------------------------------------------------
# gvtrack.create("chip.sum", "dense_track", "sum")
# out <- gextract("chip.sum", regions, iterator = 200)

## ----eval = FALSE-------------------------------------------------------------
# gvtrack.create("chip.shifted", "dense_track", "sum")
# gvtrack.iterator("chip.shifted", sshift = -100, eshift = 100)
# out <- gextract("chip.shifted", regions, iterator = 200)

## ----eval = FALSE-------------------------------------------------------------
# library(misha)
# gdb.init_examples()
# 
# # 1) pick scope
# regions <- gintervals(1, 0, 50000)
# 
# # 2) inspect available tracks
# print(gtrack.ls())
# 
# # 3) extract signal with a chosen iterator
# chip <- gextract("dense_track", regions, iterator = 100)
# 
# # 4) screen high-signal bins (as a simple peak-like filter)
# hi_chip <- gscreen("dense_track > 0.6", regions, iterator = 100)
# 
# # 5) summarize distribution/coverage
# stats <- gsummary("dense_track", regions, iterator = 100)

## ----eval = FALSE-------------------------------------------------------------
# regions <- gintervals(1, c(1000, 2000), c(1020, 2020))
# seqs <- gseq.extract(regions)
# 
# pssm <- matrix(c(
#     0.80, 0.05, 0.10, 0.05,
#     0.10, 0.10, 0.70, 0.10,
#     0.05, 0.80, 0.05, 0.10,
#     0.10, 0.10, 0.10, 0.70
# ), ncol = 4, byrow = TRUE)
# colnames(pssm) <- c("A", "C", "G", "T")
# 
# scores <- gseq.pwm(seqs, pssm, mode = "lse")

