/*
 * Decompiled with CFR 0.152.
 */
package internal.spreadsheet.base.api;

import internal.spreadsheet.base.api.SpreadSheetConnection;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataHierarchy;
import jdplus.toolkit.base.tsp.stream.DataSetTs;
import jdplus.toolkit.base.tsp.stream.HasTsStream;
import jdplus.toolkit.base.tsp.util.DataSetConversion;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import jdplus.toolkit.base.tsp.util.ResourceFactory;
import jdplus.toolkit.base.tsp.util.ResourcePool;
import lombok.Generated;
import lombok.NonNull;

public final class SpreadSheetSupport
implements HasDataHierarchy,
HasTsStream {
    @NonNull
    private final String providerName;
    @NonNull
    private final ResourceFactory<SpreadSheetConnection> spreadsheet;
    @NonNull
    private final DataSetConversion<SpreadSheetConnection, String> sheetName;
    @NonNull
    private final DataSetConversion<SpreadSheetConnection, String> seriesName;
    public static final String SHEET_NAME_META = "sheet.name";
    public static final String SHEET_GRID_LAYOUT_META = "sheet.gridLayout";
    public static final String SERIES_NAME_META = "series.name";

    @NonNull
    public List<DataSet> children(@NonNull DataSource dataSource) throws IllegalArgumentException, IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        try (SpreadSheetConnection connection = (SpreadSheetConnection)this.spreadsheet.open(dataSource);){
            DataSet.Converter sheetNameConverter = this.sheetName.getConverter((Object)connection);
            List<DataSet> list = connection.getSheetNames().stream().map(SpreadSheetSupport.childrenMapper(dataSource, (DataSet.Converter<String>)sheetNameConverter)).collect(Collectors.toList());
            return list;
        }
    }

    @NonNull
    public List<DataSet> children(@NonNull DataSet parent) throws IllegalArgumentException, IOException {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)parent);
        try (SpreadSheetConnection connection = (SpreadSheetConnection)this.spreadsheet.open(parent.getDataSource());){
            DataSet.Converter sheetNameConverter = this.sheetName.getConverter((Object)connection);
            DataSet.Converter seriesNameConverter = this.seriesName.getConverter((Object)connection);
            List<DataSet> list = connection.getSheetByName((String)sheetNameConverter.get(parent)).orElseThrow(() -> SpreadSheetSupport.sheetNotFound(parent)).stream().map(SpreadSheetSupport.childrenMapper(parent, (DataSet.Converter<String>)seriesNameConverter)).collect(Collectors.toList());
            return list;
        }
    }

    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSource dataSource, @NonNull TsInformationType type) throws IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        try (SpreadSheetConnection connection = (SpreadSheetConnection)this.spreadsheet.open(dataSource);){
            DataSet.Converter sheetNameConverter = this.sheetName.getConverter((Object)connection);
            DataSet.Converter seriesNameConverter = this.seriesName.getConverter((Object)connection);
            Stream<SheetTs> data = connection.getSheets().stream().flatMap(SheetTs::allOf);
            Stream<DataSetTs> stream = SpreadSheetSupport.streamOf(data, dataSource, (DataSet.Converter<String>)sheetNameConverter, (DataSet.Converter<String>)seriesNameConverter);
            return stream;
        }
    }

    @NonNull
    public Stream<DataSetTs> getData(@NonNull DataSet dataSet, @NonNull TsInformationType type) throws IllegalArgumentException, IOException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)dataSet);
        try (SpreadSheetConnection connection = (SpreadSheetConnection)this.spreadsheet.open(dataSet.getDataSource());){
            DataSet.Converter sheetNameConverter = this.sheetName.getConverter((Object)connection);
            DataSet.Converter seriesNameConverter = this.seriesName.getConverter((Object)connection);
            Stream<SheetTs> data = connection.getSheetByName((String)sheetNameConverter.get(dataSet)).map(SheetTs::allOf).orElseThrow(() -> SpreadSheetSupport.sheetNotFound(dataSet)).filter(this.getSeriesFilter(dataSet, (DataSet.Converter<String>)seriesNameConverter));
            Stream<DataSetTs> stream = SpreadSheetSupport.streamOf(data, dataSet.getDataSource(), (DataSet.Converter<String>)sheetNameConverter, (DataSet.Converter<String>)seriesNameConverter);
            return stream;
        }
    }

    private static IOException sheetNotFound(DataSet dataSet) {
        return new IOException("Sheet not found: " + dataSet.toString());
    }

    private static Function<String, DataSet> childrenMapper(DataSource dataSource, DataSet.Converter<String> sheetParam) {
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.COLLECTION);
        return o -> {
            sheetParam.set(builder, o);
            return builder.build();
        };
    }

    private static Function<Ts, DataSet> childrenMapper(DataSet parent, DataSet.Converter<String> seriesParam) {
        DataSet.Builder builder = parent.toBuilder(DataSet.Kind.SERIES);
        return o -> {
            seriesParam.set(builder, (Object)o.getName());
            return builder.build();
        };
    }

    private static Function<SheetTs, DataSet> dataMapper(DataSource dataSource, DataSet.Converter<String> sheetParam, DataSet.Converter<String> seriesParam) {
        DataSet.Builder builder = DataSet.builder((DataSource)dataSource, (DataSet.Kind)DataSet.Kind.SERIES);
        return o -> {
            sheetParam.set(builder, (Object)o.sheetName);
            seriesParam.set(builder, (Object)o.seriesName);
            return builder.build();
        };
    }

    private Predicate<SheetTs> getSeriesFilter(DataSet dataSet, DataSet.Converter<String> seriesParam) {
        switch (dataSet.getKind()) {
            case COLLECTION: {
                return o -> true;
            }
            case SERIES: {
                return o -> o.seriesName.equals(seriesParam.get(dataSet));
            }
        }
        throw new IllegalArgumentException(dataSet.getKind().name());
    }

    private static Stream<DataSetTs> streamOf(Stream<SheetTs> data, DataSource dataSource, DataSet.Converter<String> sheetParam, DataSet.Converter<String> seriesParam) {
        Function<SheetTs, DataSet> mapper = SpreadSheetSupport.dataMapper(dataSource, sheetParam, seriesParam);
        return data.map(sheetTs -> new DataSetTs((DataSet)mapper.apply((SheetTs)sheetTs), sheetTs.getLabel(), sheetTs.getMeta(), sheetTs.getData()));
    }

    @NonNull
    public static ResourcePool<SpreadSheetConnection> newConnectionPool() {
        return ResourcePool.of(PooledSpreadSheetConnection::new);
    }

    @Generated
    private SpreadSheetSupport(@NonNull String providerName, @NonNull ResourceFactory<SpreadSheetConnection> spreadsheet, @NonNull DataSetConversion<SpreadSheetConnection, String> sheetName, @NonNull DataSetConversion<SpreadSheetConnection, String> seriesName) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (spreadsheet == null) {
            throw new NullPointerException("spreadsheet is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        if (seriesName == null) {
            throw new NullPointerException("seriesName is marked non-null but is null");
        }
        this.providerName = providerName;
        this.spreadsheet = spreadsheet;
        this.sheetName = sheetName;
        this.seriesName = seriesName;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull SpreadSheetSupport of(@NonNull String providerName, @NonNull ResourceFactory<SpreadSheetConnection> spreadsheet, @NonNull DataSetConversion<SpreadSheetConnection, String> sheetName, @NonNull DataSetConversion<SpreadSheetConnection, String> seriesName) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (spreadsheet == null) {
            throw new NullPointerException("spreadsheet is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        if (seriesName == null) {
            throw new NullPointerException("seriesName is marked non-null but is null");
        }
        return new SpreadSheetSupport(providerName, spreadsheet, sheetName, seriesName);
    }

    private static final class SheetTs {
        private final String sheetName;
        private final String sheetLayout;
        private final String seriesName;
        private final TsData seriesData;

        static Stream<SheetTs> allOf(TsCollection sheet) {
            return sheet.stream().map(series -> SheetTs.of(sheet, series));
        }

        static SheetTs of(TsCollection sheet, Ts series) {
            return new SheetTs(sheet.getName(), sheet.getMeta().getOrDefault("gridLayout", ""), series.getName(), series.getData());
        }

        TsData getData() {
            return this.seriesData;
        }

        Map<String, String> getMeta() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(SpreadSheetSupport.SHEET_NAME_META, this.sheetName);
            result.put(SpreadSheetSupport.SHEET_GRID_LAYOUT_META, this.sheetLayout);
            result.put(SpreadSheetSupport.SERIES_NAME_META, this.seriesName);
            return result;
        }

        String getLabel() {
            return this.sheetName + "\n" + this.seriesName;
        }

        @Generated
        public SheetTs(String sheetName, String sheetLayout, String seriesName, TsData seriesData) {
            this.sheetName = sheetName;
            this.sheetLayout = sheetLayout;
            this.seriesName = seriesName;
            this.seriesData = seriesData;
        }
    }

    private static final class PooledSpreadSheetConnection
    implements SpreadSheetConnection {
        @NonNull
        private final SpreadSheetConnection delegate;
        @NonNull
        private final Closeable onClose;

        @Generated
        public PooledSpreadSheetConnection(@NonNull SpreadSheetConnection delegate, @NonNull Closeable onClose) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (onClose == null) {
                throw new NullPointerException("onClose is marked non-null but is null");
            }
            this.delegate = delegate;
            this.onClose = onClose;
        }

        @Override
        @Generated
        public Optional<TsCollection> getSheetByName(String name) throws IOException {
            return this.delegate.getSheetByName(name);
        }

        @Override
        @Generated
        public List<String> getSheetNames() throws IOException {
            return this.delegate.getSheetNames();
        }

        @Override
        @Generated
        public List<TsCollection> getSheets() throws IOException {
            return this.delegate.getSheets();
        }

        @Override
        @Generated
        public void close() throws IOException {
            this.onClose.close();
        }
    }
}

