/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.arima;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class SsfAr {
    public static StateComponent of(@NonNull double[] ar, double var, int nlags) {
        if (ar == null) {
            throw new NullPointerException("ar is marked non-null but is null");
        }
        return SsfAr.of(ar, var, nlags, false);
    }

    public static StateComponent of(@NonNull double[] ar, double var, int nlags, boolean zeroinit) {
        if (ar == null) {
            throw new NullPointerException("ar is marked non-null but is null");
        }
        if (ar.length == 0) {
            throw new IllegalArgumentException();
        }
        if (nlags < ar.length) {
            nlags = ar.length;
        }
        Data data = new Data(ar, var, nlags);
        return new StateComponent(new Initialization(data, zeroinit), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    @Generated
    private SsfAr() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class Data {
        private final double[] phi;
        private final double var;
        private final int dim;

        Polynomial ar() {
            double[] c = new double[1 + this.phi.length];
            c[0] = 1.0;
            for (int i = 0; i < this.phi.length; ++i) {
                c[i + 1] = -this.phi[i];
            }
            return Polynomial.ofInternal(c);
        }

        int dim() {
            return this.dim;
        }

        @Generated
        public Data(double[] phi, double var, int dim) {
            this.phi = phi;
            this.var = var;
            this.dim = dim;
        }

        @Generated
        public double[] getPhi() {
            return this.phi;
        }

        @Generated
        public double getVar() {
            return this.var;
        }

        @Generated
        public int getDim() {
            return this.dim;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (Double.compare(this.getVar(), other.getVar()) != 0) {
                return false;
            }
            if (this.getDim() != other.getDim()) {
                return false;
            }
            return Arrays.equals(this.getPhi(), other.getPhi());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $var = Double.doubleToLongBits(this.getVar());
            result = result * 59 + (int)($var >>> 32 ^ $var);
            result = result * 59 + this.getDim();
            result = result * 59 + Arrays.hashCode(this.getPhi());
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "SsfAr.Data(phi=" + Arrays.toString(this.getPhi()) + ", var=" + this.getVar() + ", dim=" + this.getDim() + ")";
        }
    }

    private static class Initialization
    implements ISsfInitialization {
        private final Data info;
        private final boolean zeroinit;

        Initialization(Data info, boolean zeroinit) {
            this.info = info;
            this.zeroinit = zeroinit;
        }

        @Override
        public int getStateDim() {
            return this.info.dim();
        }

        @Override
        public boolean isDiffuse() {
            return false;
        }

        @Override
        public int getDiffuseDim() {
            return 0;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pi0(FastMatrix pf0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            if (!this.zeroinit) {
                AutoCovarianceFunction acf = new AutoCovarianceFunction(Polynomial.ONE, this.info.ar(), this.info.var);
                acf.prepare(pf0.getColumnsCount());
                pf0.diagonal().set(acf.get(0));
                for (int i = 1; i < pf0.getColumnsCount(); ++i) {
                    pf0.subDiagonal(i).set(acf.get(i));
                    pf0.subDiagonal(-i).set(acf.get(i));
                }
            } else {
                pf0.set(0, 0, this.info.var);
            }
        }
    }

    private static class Dynamics
    implements ISsfDynamics {
        private final Data info;
        private final DataBlock z;

        Dynamics(Data info) {
            this.info = info;
            this.z = DataBlock.make(info.dim());
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.set(0, 0, this.info.var);
        }

        @Override
        public void S(int pos, FastMatrix cm) {
            cm.set(0, 0, Math.sqrt(this.info.var));
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.subDiagonal(-1).set(1.0);
            tr.row(0).extract(0, this.info.phi.length).copyFrom(this.info.phi, 0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            double y = 0.0;
            DoubleSeqCursor.OnMutable reader = x.cursor();
            for (int i = 0; i < this.info.phi.length; ++i) {
                y += this.info.phi[i] * reader.getAndNext();
            }
            x.fshift(1);
            x.set(0, y);
        }

        @Override
        public void TVT(int pos, FastMatrix vm) {
            this.z.set(0.0);
            DataBlockIterator cols = vm.columnsIterator();
            for (int i = 0; i < this.info.phi.length; ++i) {
                this.z.addAY(this.info.phi[i], cols.next());
            }
            this.TX(pos, this.z);
            vm.downRightShift(1);
            vm.column(0).copy(this.z);
            vm.row(0).copy(this.z);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(0, 0, this.info.var);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            double first = x.get(0);
            x.bshift(1);
            x.setLast(0.0);
            if (first != 0.0) {
                for (int i = 0; i < this.info.phi.length; ++i) {
                    x.add(i, first * this.info.phi[i]);
                }
            }
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }
}

