/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.basic.MeasurementError;
import jdplus.toolkit.base.core.ssf.basic.TimeInvariantDynamics;
import jdplus.toolkit.base.core.ssf.basic.TimeInvariantLoading;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import lombok.Generated;

public final class TimeInvariantSsf {
    public static Ssf of(ISsf ssf) {
        if (!ssf.isTimeInvariant()) {
            throw new IllegalArgumentException();
        }
        ISsfError e = ssf.measurementError();
        if (e != null) {
            e = MeasurementError.of(e.at(0));
        }
        return Ssf.of(ssf.initialization(), (ISsfDynamics)TimeInvariantDynamics.of(ssf.getStateDim(), ssf.dynamics()), (ISsfLoading)TimeInvariantLoading.of(ssf.getStateDim(), ssf.loading()), e);
    }

    public static String toString(ISsf ssf) {
        StringBuilder builder = new StringBuilder();
        builder.append("Initialization").append(System.lineSeparator());
        builder.append(ssf.initialization());
        builder.append("Measurement").append(System.lineSeparator());
        builder.append(ssf.measurement());
        builder.append("Dynamics").append(System.lineSeparator());
        builder.append(ssf.dynamics());
        return builder.toString();
    }

    @Generated
    private TimeInvariantSsf() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

