/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AdvancedOneWayAnova {
    private double M;
    private double SSQ;
    private double SSM;
    private double SSR;
    private int N;
    private int DFM;
    private int DFR;
    private final List<Group> groups = new ArrayList<Group>();

    public void add(Group group) {
        this.groups.add(group);
    }

    public List<Group> groups() {
        return Collections.unmodifiableList(this.groups);
    }

    public StatisticalTest build() {
        this.DFM = this.groups.size() - 1;
        if (this.DFM < 1) {
            return null;
        }
        double Sx = 0.0;
        this.N = 0;
        for (Group g : this.groups) {
            Sx += g.sx;
            this.N += g.size();
        }
        this.M = Sx / (double)this.getN();
        this.SSQ = 0.0;
        this.SSM = 0.0;
        for (Group g : this.groups) {
            this.SSQ += g.data.ssqc(this.M);
            double dm = g.mean() - this.M;
            this.SSM += dm * dm * (double)g.size();
        }
        this.SSR = this.SSQ - this.SSM;
        this.DFR = this.N - this.groups.size();
        if (this.SSR < 0.0) {
            this.SSR = 0.0;
        }
        F f = new F(this.DFM, this.DFR);
        return TestsUtility.testOf(this.SSM / (double)this.DFM * ((double)this.DFR / this.SSR), f, TestType.Upper);
    }

    public double getM() {
        return this.M;
    }

    public double getSSQ() {
        return this.SSQ;
    }

    public double getSSM() {
        return this.SSM;
    }

    public double getSSR() {
        return this.SSR;
    }

    public int getN() {
        return this.N;
    }

    public int getDFM() {
        return this.DFM;
    }

    public int getDFR() {
        return this.DFR;
    }

    public double getR2() {
        return this.SSM / this.SSQ;
    }

    public double mean() {
        return this.M;
    }

    public double rmse() {
        return Math.sqrt(this.SSR / (double)this.DFR);
    }

    public double cv() {
        return this.rmse() / this.M;
    }

    public static final class Group {
        private final DoubleSeq data;
        private final double sx;

        public double mean() {
            return this.sx / (double)this.data.length();
        }

        public int size() {
            return this.data.length();
        }

        public Group(String name, DoubleSeq data) {
            this.data = data;
            this.sx = data.sum();
        }

        @Generated
        public DoubleSeq getData() {
            return this.data;
        }

        @Generated
        public double getSx() {
            return this.sx;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Group)) {
                return false;
            }
            Group other = (Group)o;
            if (Double.compare(this.getSx(), other.getSx()) != 0) {
                return false;
            }
            DoubleSeq this$data = this.getData();
            DoubleSeq other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $sx = Double.doubleToLongBits(this.getSx());
            result = result * 59 + (int)($sx >>> 32 ^ $sx);
            DoubleSeq $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "AdvancedOneWayAnova.Group(data=" + String.valueOf(this.getData()) + ", sx=" + this.getSx() + ")";
        }
    }
}

