/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.xml.legacy.core.XmlMetaData;
import jdplus.toolkit.base.xml.legacy.core.XmlTs;

@XmlRootElement(name="TsCollection")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TsCollectionType", propOrder={"metaData", "data"})
public class XmlTsCollection {
    @XmlElement(name="MetaData")
    @XmlJavaTypeAdapter(value=XmlMetaData.Adapter.class)
    protected Map<String, String> metaData;
    @XmlElement(name="Data", required=true)
    protected Data data;
    @XmlAttribute(name="name")
    protected String name;
    @XmlAttribute(name="source")
    protected String source;
    @XmlAttribute(name="identifier")
    protected String identifier;
    private static final Adapter ADAPTER = new Adapter();

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, String> value) {
        this.metaData = value;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data value) {
        this.data = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String value) {
        this.identifier = value;
    }

    public static TsCollection unmarshal(XmlTsCollection xml) {
        TsCollection.Builder builder = TsCollection.builder().moniker(TsMoniker.of((String)xml.source, (String)xml.identifier)).name(xml.name == null ? "set" : xml.name);
        if (xml.metaData != null) {
            builder.meta(xml.metaData);
        }
        if (xml.data != null) {
            builder.items(XmlTsCollection.unmarshal(xml.data));
        }
        return builder.build();
    }

    private static List<Ts> unmarshal(Data data) {
        return data.getTs().stream().map(XmlTs::unmarshal).collect(Collectors.toList());
    }

    public static final boolean marshal(TsCollection v, XmlTsCollection xml) {
        xml.source = v.getMoniker().getSource();
        xml.identifier = v.getMoniker().getId();
        xml.name = v.getName();
        if (!v.getMeta().isEmpty()) {
            xml.metaData = v.getMeta();
        }
        if (!v.isEmpty()) {
            xml.data = new Data();
            for (Ts s : v) {
                XmlTs xs = new XmlTs();
                XmlTs.marshal(s, xs);
                xml.data.getTs().add(xs);
            }
        }
        return true;
    }

    public static XmlAdapter<XmlTsCollection, TsCollection> getTsAdapter() {
        return ADAPTER;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"ts"})
    public static class Data {
        @XmlElement(name="Ts")
        protected List<XmlTs> ts;

        public List<XmlTs> getTs() {
            if (this.ts == null) {
                this.ts = new ArrayList<XmlTs>();
            }
            return this.ts;
        }
    }

    public static class Adapter
    extends XmlAdapter<XmlTsCollection, TsCollection> {
        public TsCollection unmarshal(XmlTsCollection v) throws Exception {
            return XmlTsCollection.unmarshal(v);
        }

        public XmlTsCollection marshal(TsCollection v) throws Exception {
            XmlTsCollection xml = new XmlTsCollection();
            XmlTsCollection.marshal(v, xml);
            return xml;
        }
    }
}

