## ----echo=FALSE---------------------------------------------------------------
# knitr::opts_knit$set(child = TRUE)
set.seed(1)

## ----rmdpartialsetup,eval=TRUE,echo=FALSE-------------------------------------
if (exists("testing")) {
	plot <- plot(1:100)
	large_plot <- plot(1:100)
	name <- "test_plot"
}

## ----fig.width=2,fig.height=2-------------------------------------------------
plot

## ----fig.width=7,fig.height=7-------------------------------------------------
large_plot

## -----------------------------------------------------------------------------
library(rmdpartials)
library(ggplot2)
x <- rnorm(100)
y <- x + rnorm(100) + 0.5 * x^2
curve <- ggplot(mapping = aes(x, y)) + geom_point()
enlarge_plot(curve, large_plot = curve + theme_classic(base_size = 20), plot_name = "myplot")

## ----rmdpartialsetup,eval=TRUE,echo=FALSE-------------------------------------
if (exists("testing")) {
  data("ChickWeight")
  regression <- lm(weight ~ Time, data = ChickWeight)
}

## -----------------------------------------------------------------------------
knitr::kable(coef(regression))

## -----------------------------------------------------------------------------
pars <- par(ask = FALSE)
plot(regression$model[,1], fitted(regression))

## -----------------------------------------------------------------------------
plot(regression, ask = FALSE)
par(pars)

## -----------------------------------------------------------------------------
reg <- lm(y ~ x)
regression_diagnostics(reg)

## -----------------------------------------------------------------------------
x <- 5
y <- 9
partial(text = "`r x` `r y`")

## -----------------------------------------------------------------------------
getwd()

## -----------------------------------------------------------------------------
needs_preview

## -----------------------------------------------------------------------------
is_interactive

## -----------------------------------------------------------------------------
knitr::opts_knit$get("output.dir")

## -----------------------------------------------------------------------------
knitr::opts_knit$get("child")

## -----------------------------------------------------------------------------
is.null(getOption("viewer"))

## -----------------------------------------------------------------------------
!is.null(knitr::opts_knit$get("output.dir")) &&
  !identical(knitr::opts_knit$get("output.dir"), getwd())

## -----------------------------------------------------------------------------
getOption("knitr.in.progress")

## -----------------------------------------------------------------------------
getOption("rstudio.notebook.executing")

## -----------------------------------------------------------------------------
Sys.getenv("TESTTHAT_interactive")

## -----------------------------------------------------------------------------
Sys.getenv("TESTTHAT")

## -----------------------------------------------------------------------------
interactive()

## -----------------------------------------------------------------------------
ls()

## -----------------------------------------------------------------------------
print(knitr::opts_knit$get())

## -----------------------------------------------------------------------------
print(knitr::opts_chunk$get())

## -----------------------------------------------------------------------------
print(Sys.getenv())

## -----------------------------------------------------------------------------
print(options())

## -----------------------------------------------------------------------------
knit_child_debug()

