/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

static inline herr_t
H5TS_barrier_wait(H5TS_barrier_t *barrier)
{
    if (H5_UNLIKELY(NULL == barrier))
        return FAIL;

#ifdef H5_HAVE_PTHREAD_BARRIER
    {
        int ret = pthread_barrier_wait(barrier);
        if (H5_UNLIKELY(ret != 0 && ret != PTHREAD_BARRIER_SERIAL_THREAD))
            return FAIL;
    }
#else
    {
        const unsigned my_generation = H5TS_atomic_load_uint(&barrier->generation);

        
        if (1 == H5TS_atomic_fetch_sub_uint(&barrier->openings, 1)) {
            H5TS_atomic_store_uint(&barrier->openings, barrier->count);
            H5TS_atomic_fetch_add_uint(&barrier->generation, 1);
        }
        else {
            
            while (H5TS_atomic_load_uint(&barrier->generation) == my_generation)
                H5TS_thread_yield();
        }
    }
#endif

    return SUCCEED;
} 
