/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import internal.toolkit.base.core.dstats.ProbInvFinder;
import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.dstats.SpecialFunctions;

public class Chi2
implements ContinuousDistribution {
    public static final String NAME = "Chi2";
    private final double df;
    private double b;
    private double vm;
    private double vd;
    private double vp;

    public Chi2(double df) {
        if (df <= 0.0) {
            throw new IllegalArgumentException("The degrees of freedom should be strictly positive");
        }
        this.df = df;
        this.fillHelpers();
    }

    public double getDegreesofFreedom() {
        return this.df;
    }

    public double getDensity(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return SpecialFunctions.chiSquareDensity(x, this.df);
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Chi2 with ");
        sb.append(this.df);
        sb.append(" degrees of freedom ");
        return sb.toString();
    }

    public double getExpectation() {
        return this.df;
    }

    public double getVariance() {
        return this.df * 2.0;
    }

    public double getSkewness() {
        return 2.0 * Math.sqrt(2.0 / this.df);
    }

    public double getKurtosis() {
        return 3.0 + 12.0 / this.df;
    }

    public double getLeftBound() {
        return 0.0;
    }

    public double getProbability(double x, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return 0.0;
        }
        double res = SpecialFunctions.chiSquare(x, this.df);
        if (pt == ProbabilityType.Upper) {
            res = 1.0 - res;
        }
        return res;
    }

    public double getProbabilityInverse(double p, ProbabilityType pt) {
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        if (p < 1.0E-15 || 1.0 - p < 1.0E-15) {
            throw new DStatException("Can't compute probability inverse (value is too near 0 or 1)", NAME);
        }
        double start = this.df;
        return ProbInvFinder.find(p, start, 1.0E-15, 1.0E-9, this);
    }

    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    public BoundaryType hasLeftBound() {
        return this.df <= 2.0 ? BoundaryType.Asymptotical : BoundaryType.Finite;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    public boolean isSymmetrical() {
        return false;
    }

    public double random(RandomNumberGenerator rng) {
        double z;
        if (this.df == 1.0) {
            double z2;
            while (true) {
                double u = rng.nextDouble();
                double v = rng.nextDouble() * 0.857763884960707;
                z2 = v / u;
                if (z2 < 0.0) continue;
                double zz = z2 * z2;
                double r = 2.5 - zz;
                if (z2 < 0.0) {
                    r += zz * z2 / (3.0 * z2);
                }
                if (u < r * 0.3894003915) {
                    return z2 * z2;
                }
                if (!(zz > 1.036961043 / u + 1.4) && 2.0 * Math.log(u) < -zz * 0.5) break;
            }
            return z2 * z2;
        }
        while (true) {
            double u = rng.nextDouble();
            double v = rng.nextDouble() * this.vd + this.vm;
            z = v / u;
            if (z < -this.b) continue;
            double zz = z * z;
            double r = 2.5 - zz;
            if (z < 0.0) {
                r += zz * z / (3.0 * (z + this.b));
            }
            if (u < r * 0.3894003915) {
                return (z + this.b) * (z + this.b);
            }
            if (!(zz > 1.036961043 / u + 1.4) && 2.0 * Math.log(u) < Math.log(1.0 + z / this.b) * this.b * this.b - zz * 0.5 - z * this.b) break;
        }
        return (z + this.b) * (z + this.b);
    }

    private void fillHelpers() {
        this.b = Math.sqrt(this.df - 1.0);
        this.vm = -0.6065306597 * (1.0 - 0.25 / (this.b * this.b + 1.0));
        this.vm = -this.b > this.vm ? -this.b : this.vm;
        this.vp = 0.6065306597 * (0.7071067812 + this.b) / (0.5 + this.b);
        this.vd = this.vp - this.vm;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NAME).append('(');
        sb.append(this.df);
        sb.append(')');
        return sb.toString();
    }
}

