/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.util.Arrays2;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.FiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.ForeFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IRationalFilter;
import jdplus.toolkit.base.core.math.linearfilters.LinearFilterException;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalForeFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public final class RationalFilter
implements IRationalFilter {
    final RationalBackFilter backFilter;
    final RationalForeFilter foreFilter;
    IFiniteFilter numerator;
    IFiniteFilter denominator;

    public static RationalFilter rationalSymmetricFilter(BackFilter N, BackFilter D) {
        Polynomial.SimplifyingTool smp = new Polynomial.SimplifyingTool();
        if (smp.simplify(N.asPolynomial(), D.asPolynomial())) {
            N = new BackFilter((Polynomial)smp.getLeft());
            D = new BackFilter((Polynomial)smp.getRight());
        }
        SymmetricFilter n = SymmetricFilter.convolutionOf(N);
        BackFilter g = n.decompose(D);
        RationalBackFilter rb = new RationalBackFilter(g, D, 0);
        return RationalFilter.builder().backFilter(rb).foreFilter(rb.mirror()).numerator(SymmetricFilter.convolutionOf(N)).denominator(SymmetricFilter.convolutionOf(D)).build();
    }

    public static RationalFilter of(BackFilter bnum, BackFilter bdenom, ForeFilter fnum, ForeFilter fdenom) {
        FiniteFilter num = FiniteFilter.multiply((IFiniteFilter)bnum, fnum);
        Decomposition decomp = Decomposition.of(num, bdenom, fdenom);
        return RationalFilter.builder().backFilter(decomp.getBackFilter()).foreFilter(decomp.getForeFilter()).numerator(num).denominator(FiniteFilter.multiply((IFiniteFilter)bdenom, fdenom)).build();
    }

    public static RationalFilter of(RationalForeFilter rf) {
        return RationalFilter.builder().backFilter(RationalBackFilter.ZERO).foreFilter(rf).numerator(new FiniteFilter(rf.getNumerator())).denominator(new FiniteFilter(rf.getDenominator())).build();
    }

    public static RationalFilter of(RationalBackFilter rb) {
        return RationalFilter.builder().backFilter(rb).foreFilter(RationalForeFilter.ZERO).numerator(new FiniteFilter(rb.getNumerator())).denominator(new FiniteFilter(rb.getDenominator())).build();
    }

    public static RationalFilter of(IFiniteFilter N, BackFilter DB, ForeFilter DF) {
        FiniteFilter num = new FiniteFilter(N);
        FiniteFilter denom = FiniteFilter.multiply((IFiniteFilter)new FiniteFilter(DB), DF);
        Decomposition decomp = Decomposition.of(num, DB, DF);
        return RationalFilter.builder().backFilter(decomp.getBackFilter()).foreFilter(decomp.getForeFilter()).numerator(num).denominator(denom).build();
    }

    @Override
    public Complex frequencyResponse(double freq) {
        if (this.numerator != null && this.denominator != null) {
            Complex nb = this.numerator.frequencyResponse(freq);
            Complex nf = this.denominator.frequencyResponse(freq);
            return nb.div(nf);
        }
        Complex nb = this.backFilter.frequencyResponse(freq);
        Complex nf = this.foreFilter.frequencyResponse(freq);
        return nb.plus(nf);
    }

    @Override
    public IFiniteFilter getDenominator() {
        if (this.denominator == null) {
            BackFilter bfilter = this.backFilter.getDenominator();
            ForeFilter ffilter = this.foreFilter.getDenominator();
            if (bfilter.asPolynomial().equals(ffilter.asPolynomial(), 0.0)) {
                this.denominator = SymmetricFilter.convolutionOf(bfilter);
            } else {
                FiniteFilter b = new FiniteFilter(bfilter);
                FiniteFilter f = new FiniteFilter(ffilter);
                FiniteFilter d = FiniteFilter.multiply((IFiniteFilter)b, f);
                this.denominator = d;
            }
        }
        return this.denominator;
    }

    public int getLBound() {
        return this.backFilter.getUBound();
    }

    @Override
    public IFiniteFilter getNumerator() {
        if (this.numerator == null) {
            FiniteFilter nb = new FiniteFilter(this.backFilter.getNumerator());
            FiniteFilter nf = new FiniteFilter(this.foreFilter.getNumerator());
            FiniteFilter db = new FiniteFilter(this.backFilter.getDenominator());
            FiniteFilter df = new FiniteFilter(this.foreFilter.getDenominator());
            FiniteFilter n = FiniteFilter.add((IFiniteFilter)FiniteFilter.multiply((IFiniteFilter)nb, df), FiniteFilter.multiply((IFiniteFilter)nf, db));
            this.numerator = n;
        }
        return this.numerator;
    }

    @Override
    public RationalBackFilter getRationalBackFilter() {
        return this.backFilter;
    }

    @Override
    public RationalForeFilter getRationalForeFilter() {
        return this.foreFilter;
    }

    public int getUBound() {
        return this.foreFilter.getUBound();
    }

    public double weight(int pos) {
        double d = 0.0;
        if (pos <= this.backFilter.getUBound()) {
            d = this.backFilter.weight(pos);
        }
        if (pos >= this.foreFilter.getLBound()) {
            d += this.foreFilter.weight(pos);
        }
        return d;
    }

    public IntToDoubleFunction weights() {
        return pos -> this.weight(pos);
    }

    @Override
    public boolean hasLowerBound() {
        return this.backFilter.hasLowerBound();
    }

    @Override
    public boolean hasUpperBound() {
        return this.foreFilter.hasUpperBound();
    }

    public void prepare(int n, int m) {
        this.backFilter.prepare(n);
        this.foreFilter.prepare(m);
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public RationalBackFilter getBackFilter() {
        return this.backFilter;
    }

    @Generated
    public RationalForeFilter getForeFilter() {
        return this.foreFilter;
    }

    @Generated
    public RationalFilter(RationalBackFilter backFilter, RationalForeFilter foreFilter, IFiniteFilter numerator, IFiniteFilter denominator) {
        this.backFilter = backFilter;
        this.foreFilter = foreFilter;
        this.numerator = numerator;
        this.denominator = denominator;
    }

    @Generated
    public static class Builder {
        @Generated
        private RationalBackFilter backFilter;
        @Generated
        private RationalForeFilter foreFilter;
        @Generated
        private IFiniteFilter numerator;
        @Generated
        private IFiniteFilter denominator;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder backFilter(RationalBackFilter backFilter) {
            this.backFilter = backFilter;
            return this;
        }

        @Generated
        public @NonNull Builder foreFilter(RationalForeFilter foreFilter) {
            this.foreFilter = foreFilter;
            return this;
        }

        @Generated
        public @NonNull Builder numerator(IFiniteFilter numerator) {
            this.numerator = numerator;
            return this;
        }

        @Generated
        public @NonNull Builder denominator(IFiniteFilter denominator) {
            this.denominator = denominator;
            return this;
        }

        @Generated
        public @NonNull RationalFilter build() {
            return new RationalFilter(this.backFilter, this.foreFilter, this.numerator, this.denominator);
        }

        @Generated
        public @NonNull String toString() {
            return "RationalFilter.Builder(backFilter=" + String.valueOf(this.backFilter) + ", foreFilter=" + String.valueOf(this.foreFilter) + ", numerator=" + String.valueOf(this.numerator) + ", denominator=" + String.valueOf(this.denominator) + ")";
        }
    }

    public static class Decomposition {
        private final RationalBackFilter backFilter;
        private final RationalForeFilter foreFilter;

        public static Decomposition of(IFiniteFilter num, BackFilter dbf, ForeFilter dff) {
            int i;
            int k;
            int nnf;
            int nnb0 = -num.getLowerBound();
            int nnf0 = num.getUpperBound();
            double[] nc = num.weightsToArray();
            int nnb = nnb0;
            if (nnb < 0) {
                nnb = 0;
            }
            if ((nnf = nnf0) < 0) {
                nnf = 0;
            }
            int ndb = -dbf.getLowerBound();
            int ndf = dff.getUpperBound();
            int h = Math.max(nnf, ndf);
            int ne = h + (k = Math.max(nnb, ndb)) + 1;
            if (nc.length != ne) {
                double[] ntmp = new double[ne];
                System.arraycopy(nc, 0, ntmp, k - nnb0, nc.length);
                nc = ntmp;
            }
            double[] cnb = new double[k + 1];
            double[] cnf = new double[h + 1];
            cnf[0] = 0.0;
            double[] db = dbf.weightsToArray();
            double[] df = dff.weightsToArray();
            FastMatrix m = FastMatrix.square(ne);
            for (i = 0; i <= ndf; ++i) {
                for (int j = 0; j <= k; ++j) {
                    m.set(i + j, j, df[i]);
                }
            }
            i = -ndb + 1 + k;
            for (int ii = 0; ii <= ndb; ++ii) {
                for (int j = 0; j < h; ++j) {
                    m.set(i + j, j + k + 1, db[ii]);
                }
                ++i;
            }
            try {
                LinearSystemSolver.robustSolver().solve(m, DataBlock.of(nc));
            }
            catch (MatrixException e) {
                throw new LinearFilterException("Invalid decomposition of rational filter");
            }
            for (i = 0; i <= k; ++i) {
                cnb[i] = nc[i];
            }
            for (i = 1; i <= h; ++i) {
                cnf[i] = nc[i + k];
            }
            Arrays2.reverse((double[])cnb);
            return new Decomposition(new RationalBackFilter(BackFilter.ofInternal(cnb), dbf, 0), new RationalForeFilter(ForeFilter.ofInternal(cnf), dff, 0));
        }

        @Generated
        public RationalBackFilter getBackFilter() {
            return this.backFilter;
        }

        @Generated
        public RationalForeFilter getForeFilter() {
            return this.foreFilter;
        }

        @Generated
        private Decomposition(RationalBackFilter backFilter, RationalForeFilter foreFilter) {
            this.backFilter = backFilter;
            this.foreFilter = foreFilter;
        }
    }
}

