/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regular.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.GenericTradingDays;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.modelling.regression.GenericTradingDaysFactory;
import jdplus.toolkit.base.core.stats.RobustCovarianceComputer;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class CanovaHansenForTradingDays {
    private final FastMatrix x;
    private final FastMatrix xe;
    private final FastMatrix cxe;
    private final FastMatrix phi;
    private final DoubleSeq c;
    private final DoubleSeq u;
    private final int nx;
    private final int ntd;

    public static Builder test(TsData s) {
        return new Builder(s);
    }

    public DoubleSeq getE() {
        return this.u;
    }

    private CanovaHansenForTradingDays(LinearModel lm, int ntd, WindowFunction winFunction, int truncationLag) {
        this.ntd = ntd;
        this.x = lm.variables();
        this.nx = this.x.getColumnsCount();
        LeastSquaresResults olsResults = Ols.compute(lm);
        this.c = olsResults.getCoefficients();
        this.u = lm.calcResiduals(this.c);
        this.xe = this.x.deepClone();
        this.xe.applyByColumns(col -> col.apply(this.u, (a, b) -> a * b));
        this.phi = RobustCovarianceComputer.covariance(this.xe, winFunction, truncationLag);
        this.cxe = this.xe.deepClone();
        this.cxe.applyByColumns(col -> col.cumul());
    }

    public double test(int var) {
        int dx = this.nx - this.ntd;
        int dvar = var + dx;
        return CanovaHansenForTradingDays.computeStat(this.phi.extract(dvar, 1, dvar, 1), this.cxe.extract(0, this.cxe.getRowsCount(), dvar, 1));
    }

    public double test(int var, int nvars) {
        int dx = this.nx - this.ntd;
        int dvar = var + dx;
        return CanovaHansenForTradingDays.computeStat(this.phi.extract(dvar, nvars, dvar, nvars), this.cxe.extract(0, this.cxe.getRowsCount(), dvar, nvars));
    }

    public double testDerived() {
        int dx = this.nx - this.ntd;
        FastMatrix tphi = this.phi.extract(dx, this.ntd, dx, this.ntd);
        DataBlock tc = DataBlock.of(this.c.extract(dx, this.ntd));
        double v = QuadraticForm.apply(tphi, tc);
        FastMatrix V = FastMatrix.square(1);
        V.set(0, 0, v);
        FastMatrix ce = this.cxe.extract(0, this.cxe.getRowsCount(), dx, this.ntd);
        FastMatrix E = FastMatrix.make(ce.getRowsCount(), 1);
        E.column(0).product(ce.rowsIterator(), tc);
        return CanovaHansenForTradingDays.computeStat(V, E);
    }

    public double testAll() {
        return this.test(0, this.ntd);
    }

    private static double computeStat(FastMatrix O, FastMatrix cx) {
        int n = cx.getRowsCount();
        int ncx = cx.getColumnsCount();
        FastMatrix FF = FastMatrix.square(ncx);
        for (int i = 0; i < n; ++i) {
            FF.addXaXt(1.0, cx.row(i));
        }
        FastMatrix sig = O.deepClone();
        SymmetricMatrix.lcholesky(sig);
        LowerTriangularMatrix.solveLX(sig, FF);
        LowerTriangularMatrix.solveLtX(sig, FF);
        double tr = FF.diagonal().sum();
        return tr / (double)(n * n);
    }

    private FastMatrix robustCovarianceOfCoefficients() {
        FastMatrix Lo = this.phi.deepClone();
        SymmetricMatrix.lcholesky(Lo);
        LowerTriangularMatrix.toLower(Lo);
        FastMatrix Lx = SymmetricMatrix.XtX(this.x);
        SymmetricMatrix.lcholesky(Lx);
        LowerTriangularMatrix.solveLX(Lx, Lo);
        LowerTriangularMatrix.solveLtX(Lx, Lo);
        FastMatrix XXt = SymmetricMatrix.XXt(Lo);
        XXt.mul(this.xe.getRowsCount());
        return XXt;
    }

    public StatisticalTest tdTest() {
        int dx = this.nx - this.ntd;
        FastMatrix rcov = this.robustCovarianceOfCoefficients().extract(dx, this.ntd, dx, this.ntd);
        SymmetricMatrix.lcholesky(rcov);
        LowerTriangularMatrix.toLower(rcov);
        DataBlock b = DataBlock.of(this.c.extract(dx, this.ntd));
        LowerTriangularMatrix.solveLx(rcov, b);
        double fval = b.ssq() / (double)this.ntd;
        F f = new F(this.ntd, this.x.getRowsCount() - this.c.length());
        return TestsUtility.testOf(fval, f, TestType.Upper);
    }

    public static class Builder {
        private final TsData s;
        private int[] differencingLags;
        private WindowFunction winFunction = WindowFunction.Bartlett;
        private int truncationLag = 15;

        private Builder(TsData s) {
            this.s = s;
        }

        public Builder differencingLags(int ... lags) {
            this.differencingLags = lags;
            return this;
        }

        public Builder truncationLag(int truncationLag) {
            this.truncationLag = truncationLag;
            return this;
        }

        public Builder windowFunction(WindowFunction winFunction) {
            this.winFunction = winFunction;
            return this;
        }

        public CanovaHansenForTradingDays build() {
            FastMatrix x = this.sx();
            LinearModel lm = this.buildModel(x);
            return new CanovaHansenForTradingDays(lm, x.getColumnsCount(), this.winFunction, this.truncationLag);
        }

        private FastMatrix sx() {
            GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)DayClustering.TD7);
            int n = this.s.length();
            FastMatrix m = FastMatrix.make(n, 6);
            GenericTradingDaysFactory.FACTORY.fill(gtd, this.s.getStart(), m);
            FastMatrix dm = m;
            if (this.differencingLags != null) {
                for (int j = 0; j < this.differencingLags.length; ++j) {
                    int lag = this.differencingLags[j];
                    if (lag <= 0) continue;
                    FastMatrix mj = dm;
                    int nr = mj.getRowsCount();
                    int nc = mj.getColumnsCount();
                    dm = mj.extract(lag, nr - lag, 0, nc).deepClone();
                    dm.sub(mj.extract(0, nr - lag, 0, nc));
                }
            }
            return dm;
        }

        private DoubleSeq y() {
            DoubleSeq dy = this.s.getValues();
            if (this.differencingLags != null) {
                for (int j = 0; j < this.differencingLags.length; ++j) {
                    int lag = this.differencingLags[j];
                    if (lag <= 0) continue;
                    dy = dy.delta(lag);
                }
            }
            return dy;
        }

        private LinearModel buildModel(FastMatrix sx) {
            return LinearModel.builder().y(this.y()).addX((Matrix)sx).meanCorrection(true).build();
        }
    }
}

