/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.ResultsRange;
import jdplus.toolkit.base.core.ssf.univariate.DefaultDisturbanceSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.DefaultFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.IDisturbanceSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;
import lombok.NonNull;

public class DisturbanceSmoother {
    private final ISsf ssf;
    private final ISsfDynamics dynamics;
    private final ISsfLoading loading;
    private final ISsfError error;
    private final boolean calcvar;
    private final boolean rescalevar;
    private IDisturbanceSmoothingResults srslts;
    private DefaultFilteringResults frslts;
    private double err;
    private double errVariance;
    private double esm;
    private double esmVariance;
    private double h;
    private DataBlock K;
    private DataBlock R;
    private DataBlock U;
    private FastMatrix N;
    private FastMatrix UVar;
    private FastMatrix S;
    private boolean missing;
    private int pos;
    private int stop;
    private DataBlock tmp;
    private double c;
    private double v;

    public static Builder builder(ISsf ssf) {
        return new Builder(ssf);
    }

    private DisturbanceSmoother(ISsf ssf, boolean calcvar, boolean rescalevar) {
        this.ssf = ssf;
        this.calcvar = calcvar;
        this.rescalevar = rescalevar;
        this.dynamics = ssf.dynamics();
        this.loading = ssf.measurement().loading();
        this.error = ssf.measurement().error();
    }

    public boolean process(ISsfData data) {
        OrdinaryFilter filter = new OrdinaryFilter();
        DefaultFilteringResults fresults = DefaultFilteringResults.light();
        fresults.prepare(this.ssf, this.stop, data.length());
        if (!filter.process(this.ssf, data, fresults)) {
            return false;
        }
        return this.process(0, data.length(), fresults);
    }

    public boolean process(@NonNull DefaultFilteringResults results) {
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        ResultsRange range = results.getRange();
        return this.process(range.getStart(), range.getEnd(), results);
    }

    public boolean process(int start, int end, @NonNull DefaultFilteringResults results) {
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        DefaultDisturbanceSmoothingResults sresults = this.calcvar ? DefaultDisturbanceSmoothingResults.full(this.ssf.measurement().hasError()) : DefaultDisturbanceSmoothingResults.light(this.ssf.measurement().hasError());
        sresults.prepare(this.ssf, start, end);
        return this.process(start, end, results, sresults);
    }

    public boolean process(ISsfData data, @NonNull IDisturbanceSmoothingResults sresults, int stop) {
        if (sresults == null) {
            throw new NullPointerException("sresults is marked non-null but is null");
        }
        OrdinaryFilter filter = new OrdinaryFilter();
        DefaultFilteringResults fresults = DefaultFilteringResults.light();
        fresults.prepare(this.ssf, stop, data.length());
        if (!filter.process(this.ssf, data, fresults)) {
            return false;
        }
        return this.process(stop, data.length(), fresults, sresults);
    }

    public boolean process(int start, int end, DefaultFilteringResults results, IDisturbanceSmoothingResults sresults) {
        this.frslts = results;
        this.srslts = sresults;
        this.stop = start;
        this.pos = end;
        this.initSmoother(this.ssf);
        while (--this.pos >= this.stop) {
            this.loadInfo();
            if (!this.iterate()) continue;
            this.srslts.saveSmoothedTransitionDisturbances(this.pos, this.U, this.UVar == null ? null : this.UVar);
            if (this.error == null) continue;
            this.srslts.saveSmoothedMeasurementDisturbance(this.pos, this.esm, this.esmVariance);
        }
        if (this.rescalevar) {
            this.srslts.rescaleVariances(results.var());
        }
        return true;
    }

    public boolean resume(int start) {
        this.stop = start;
        while (this.pos >= this.stop) {
            this.loadInfo();
            if (this.iterate()) {
                this.srslts.saveSmoothedTransitionDisturbances(this.pos, this.U, this.UVar);
                if (this.error != null) {
                    this.srslts.saveSmoothedMeasurementDisturbance(this.pos, this.esm, this.esmVariance);
                }
            }
            --this.pos;
        }
        return true;
    }

    public IDisturbanceSmoothingResults getResults() {
        return this.srslts;
    }

    public DataBlock getFinalR() {
        return this.R;
    }

    public FastMatrix getFinalN() {
        return this.N;
    }

    private void initSmoother(ISsf ssf) {
        int dim = ssf.getStateDim();
        int resdim = this.dynamics.getInnovationsDim();
        this.R = DataBlock.make(dim);
        this.K = DataBlock.make(dim);
        this.U = DataBlock.make(resdim);
        if (this.calcvar) {
            this.S = FastMatrix.make(dim, resdim);
            this.N = FastMatrix.square(dim);
            this.tmp = DataBlock.make(dim);
            this.UVar = FastMatrix.square(resdim);
            if (this.error == null) {
                this.h = 0.0;
            } else if (this.error.isTimeInvariant()) {
                this.h = this.error.at(0);
            }
            if (this.dynamics.isTimeInvariant()) {
                this.dynamics.S(0, this.S);
            }
        }
    }

    private void loadInfo() {
        this.err = this.frslts.error(this.pos);
        boolean bl = this.missing = !Double.isFinite(this.err);
        if (!this.missing) {
            this.errVariance = this.frslts.errorVariance(this.pos);
            this.K.setAY(1.0 / this.errVariance, this.frslts.M(this.pos));
            this.dynamics.TX(this.pos, this.K);
        }
        if (this.pos > 0) {
            if (!this.dynamics.isTimeInvariant() && this.S != null) {
                this.S.set(0.0);
                this.dynamics.S(this.pos - 1, this.S);
            }
            if (this.error != null && !this.error.isTimeInvariant()) {
                this.h = this.error.at(this.pos - 1);
            }
        }
    }

    private boolean iterate() {
        this.iterateR();
        if (this.calcvar) {
            this.iterateN();
        }
        if (this.pos > 0) {
            this.esm = this.c * this.h;
            if (this.dynamics.hasInnovations(this.pos - 1)) {
                this.dynamics.XS(this.pos - 1, this.R, this.U);
                if (this.calcvar) {
                    this.esmVariance = this.h - this.h * this.h * this.v;
                    SymmetricMatrix.XtSX(this.N, this.S, this.UVar);
                    this.UVar.chs();
                    this.UVar.diagonal().add(1.0);
                }
            } else {
                this.U.set(0.0);
                if (this.calcvar) {
                    this.UVar.set(0.0);
                }
            }
        }
        return true;
    }

    private void iterateN() {
        if (!this.missing && this.errVariance != 0.0) {
            this.tmp.product(this.N.rowsIterator(), this.K);
            this.v = 1.0 / this.errVariance + this.tmp.dot(this.K);
            this.dynamics.XT(this.pos, this.tmp);
            this.tvt(this.N);
            this.loading.VpZdZ(this.pos, this.N, this.v);
            this.subZ(this.N.rowsIterator(), this.tmp);
            this.subZ(this.N.columnsIterator(), this.tmp);
        } else {
            this.tvt(this.N);
        }
        SymmetricMatrix.reenforceSymmetry(this.N);
    }

    private void iterateR() {
        if (!this.missing && this.errVariance != 0.0) {
            this.c = this.err / this.errVariance - this.R.dot(this.K);
            this.dynamics.XT(this.pos, this.R);
            this.loading.XpZd(this.pos, this.R, this.c);
        } else {
            this.dynamics.XT(this.pos, this.R);
            this.c = Double.NaN;
        }
    }

    private void tvt(FastMatrix N) {
        N.columns().forEach(col -> this.dynamics.XT(this.pos, (DataBlock)col));
        N.rows().forEach(row -> this.dynamics.XT(this.pos, (DataBlock)row));
    }

    private void subZ(DataBlockIterator rows, DataBlock b) {
        DoubleSeqCursor.OnMutable x = b.cursor();
        while (rows.hasNext()) {
            double cur = x.getAndNext();
            if (cur == 0.0) continue;
            this.loading.XpZd(this.pos, rows.next(), -cur);
        }
    }

    public DataBlock firstSmoothedState() {
        int n = this.ssf.getStateDim();
        DataBlock a = DataBlock.make(n);
        FastMatrix Pf0 = FastMatrix.square(n);
        this.ssf.initialization().a0(a);
        this.ssf.initialization().Pf0(Pf0);
        a.addProduct(this.R, Pf0.columnsIterator());
        return a;
    }

    public static class Builder {
        private final ISsf ssf;
        private boolean rescaleVariance = false;
        private boolean calcVariance = true;

        public Builder(ISsf ssf) {
            this.ssf = ssf;
        }

        public Builder rescaleVariance(boolean rescale) {
            this.rescaleVariance = rescale;
            if (rescale) {
                this.calcVariance = true;
            }
            return this;
        }

        public Builder calcVariance(boolean calc) {
            this.calcVariance = calc;
            if (!calc) {
                this.rescaleVariance = false;
            }
            return this;
        }

        public DisturbanceSmoother build() {
            return new DisturbanceSmoother(this.ssf, this.calcVariance, this.rescaleVariance);
        }
    }
}

