/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.ssf.IPredictionErrorDecomposition;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.univariate.IFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;
import jdplus.toolkit.base.core.stats.likelihood.ResidualsCumulator;

public class PredictionErrorDecomposition
implements IPredictionErrorDecomposition,
IFilteringResults {
    protected final ResidualsCumulator cumulator = new ResidualsCumulator();
    protected DataBlock res;
    protected final boolean bres;

    public PredictionErrorDecomposition(boolean bres) {
        this.bres = bres;
    }

    public boolean hasResiduals() {
        return this.bres;
    }

    public DoubleSeq errors(boolean normalized, boolean clean) {
        if (!this.bres || !normalized) {
            return null;
        }
        if (!clean || this.res.allMatch(x -> Double.isFinite(x))) {
            return this.res;
        }
        return DataBlock.select((DoubleSeq)this.res, x -> Double.isFinite(x));
    }

    public void prepare(ISsf ssf, int n) {
        this.clear();
        if (this.bres) {
            this.res = DataBlock.make(n);
            this.res.set(() -> Double.NaN);
        }
    }

    public double residual(int pos) {
        return this.bres ? this.res.get(pos) : Double.NaN;
    }

    @Override
    public void save(int t, State state, StateInfo info) {
    }

    @Override
    public void save(int t, UpdateInformation pe) {
        double e = pe.get();
        if (pe.getStatus() == UpdateInformation.Status.OBSERVATION) {
            this.cumulator.add(e, pe.getVariance());
        }
        if (this.bres) {
            double sd = pe.getStandardDeviation();
            if (e == 0.0) {
                this.res.set(t, 0.0);
            } else if (sd == 0.0) {
                this.res.set(t, Double.NaN);
            } else {
                this.res.set(t, e / sd);
            }
        }
    }

    @Override
    public void clear() {
        this.cumulator.clear();
        this.res = null;
    }

    @Override
    public Likelihood likelihood(boolean scalingfactor) {
        return Likelihood.builder(this.cumulator.getObsCount()).ssqErr(this.cumulator.getSsqErr()).logDeterminant(this.cumulator.getLogDeterminant()).residuals((DoubleSeq)this.res).scalingFactor(scalingfactor).build();
    }
}

