/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math.linearfilters;

import jdplus.toolkit.base.api.math.linearfilters.FilterSpec;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class HendersonSpec
implements FilterSpec {
    private final int filterHorizon;
    private final double leftIcRatio;
    private final double rightIcRatio;

    public HendersonSpec(int horizon, double icRatio) {
        this.filterHorizon = horizon;
        this.leftIcRatio = icRatio;
        this.rightIcRatio = icRatio;
    }

    public boolean isSymmetric() {
        return this.leftIcRatio == this.rightIcRatio;
    }

    @Generated
    public int getFilterHorizon() {
        return this.filterHorizon;
    }

    @Generated
    public double getLeftIcRatio() {
        return this.leftIcRatio;
    }

    @Generated
    public double getRightIcRatio() {
        return this.rightIcRatio;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HendersonSpec)) {
            return false;
        }
        HendersonSpec other = (HendersonSpec)o;
        if (this.getFilterHorizon() != other.getFilterHorizon()) {
            return false;
        }
        if (Double.compare(this.getLeftIcRatio(), other.getLeftIcRatio()) != 0) {
            return false;
        }
        return Double.compare(this.getRightIcRatio(), other.getRightIcRatio()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFilterHorizon();
        long $leftIcRatio = Double.doubleToLongBits(this.getLeftIcRatio());
        result = result * 59 + (int)($leftIcRatio >>> 32 ^ $leftIcRatio);
        long $rightIcRatio = Double.doubleToLongBits(this.getRightIcRatio());
        result = result * 59 + (int)($rightIcRatio >>> 32 ^ $rightIcRatio);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "HendersonSpec(filterHorizon=" + this.getFilterHorizon() + ", leftIcRatio=" + this.getLeftIcRatio() + ", rightIcRatio=" + this.getRightIcRatio() + ")";
    }

    @Generated
    public HendersonSpec(int filterHorizon, double leftIcRatio, double rightIcRatio) {
        this.filterHorizon = filterHorizon;
        this.leftIcRatio = leftIcRatio;
        this.rightIcRatio = rightIcRatio;
    }
}

