tabPanel(
  title = "Data",
  id = "preview",
  icon = icon("magnifying-glass"),
         sidebarPanel(
           radioButtons("table_type", "Table Type",
                        c("Default" = "default", "DT" = "dt")),
           radioButtons("data_view", "Data",
                        c("Raw" = "raw",
                          "Normalized" = "normalized",
                          "Normalized Percent" = "normalized_100",
                          "Normalized Z-scale" = "normalized_z")),
           tags$div(style = "display:inline-block; width: 20px;"),
           #tags$div(style = "margin-top: 20px;"),
           #tags$br(),
           #tags$br(),
           actionButton('apply_normalization', 'Apply Norm'),
           downloadButton("download_data", "Download Data"),
           width = 3),
         mainPanel(
           tableOutput("raw"),
           DT::dataTableOutput('raw_dt'),
           tableOutput("normalized"),
           #DT::dataTableOutput('normalized_dt'),
           tableOutput("normalized_100_dt"),
           #DT::dataTableOutput('normalized_100_dt'),
           tableOutput("normalized_z"),
           #DT::dataTableOutput('normalized_z_dt'),
           width = 8))
