## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----message=FALSE------------------------------------------------------------
library(BioMoR)

# Prepare dataset: recode labels to binary
data(iris)
iris$Label <- ifelse(iris$Species == "setosa", "Active", "Inactive")

# Cross-validation control
ctrl <- get_cv_control(cv = 3)

# Train a Random Forest
fit <- train_rf(iris, outcome_col = "Label", ctrl = ctrl)

# Benchmark the model
results <- biomor_benchmark(fit, iris, outcome_col = "Label")

# Print metrics
results$metrics

## ----fig.height=4, fig.width=6------------------------------------------------
# ROC Curve
results$plots$ROC
# Precision-Recall Curve
results$plots$PR
# Threshold Optimization
results$plots$Thresholds
# Calibration Curve
results$plots$Calibration

