## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, echo=FALSE--------------------------------------------------------
library(epitraxr)

## ----get-epitrax--------------------------------------------------------------
data_fp <- "vignette-data/epitrax_data.csv"

epitrax <- create_epitrax_from_file(filepath = data_fp)

names(epitrax)

## ----add-diseases-------------------------------------------------------------
disease_lists = list(
  internal = "vignette-data/ireport_diseases.csv",
  public = "vignette-data/preport_diseases.csv"
)

epitrax <- epitrax_set_report_diseases(epitrax, disease_list_files = disease_lists)

names(epitrax)

## ----set-config---------------------------------------------------------------
config_file <- "vignette-data/config.yaml"
epitrax <- epitrax_set_config_from_file(epitrax, filepath = config_file)

names(epitrax)

## ----show-config--------------------------------------------------------------
epitrax$config

## ----conveniencefun-----------------------------------------------------------
epitrax <- setup_epitrax(
  filepath = data_fp,
  config_file = config_file,
  disease_list_files = disease_lists
)

names(epitrax)

## ----ireports-noargs----------------------------------------------------------
epitrax <- epitrax_ireport_annual_counts(epitrax)
epitrax <- epitrax_ireport_monthly_counts_all_yrs(epitrax)

names(epitrax$internal_reports)

## ----morereports--------------------------------------------------------------
epitrax <- epitrax_ireport_monthly_avgs(epitrax)
epitrax <- epitrax_ireport_ytd_counts_for_month(epitrax)
epitrax <- epitrax_preport_month_crosssections(epitrax)
epitrax <- epitrax_preport_ytd_rates(epitrax)

## ----inspect-ireports---------------------------------------------------------
names(epitrax$internal_reports)

## ----inspect-preports---------------------------------------------------------
names(epitrax$public_reports)

## ----set-fsys-----------------------------------------------------------------
tmpdir <- tempdir()
fsys <- list(
  internal = file.path(tmpdir, "internal_reports"),
  public = file.path(tmpdir, "public_reports")
)

fsys <- setup_filesystem(folders = fsys, clear.reports = TRUE)

## ----export-csv---------------------------------------------------------------
epitrax <- epitrax_write_csvs(epitrax, fsys = fsys)

list.files(fsys$internal)
list.files(fsys$public)

## ----cleanup1, include = FALSE------------------------------------------------
unlink(unlist(fsys, use.names = FALSE), recursive = TRUE)

## ----full-pipe----------------------------------------------------------------
# Data and config files
data_fp <- "vignette-data/epitrax_data.csv"
disease_lists = list(
  internal = "vignette-data/ireport_diseases.csv",
  public = "vignette-data/preport_diseases.csv"
)
config_file <- "vignette-data/config.yaml"

# Setup filesystem
tmpdir <- tempdir()
fsys <- list(
  internal = file.path(tmpdir, "internal_reports"),
  public = file.path(tmpdir, "public_reports")
)

fsys <- setup_filesystem(folders = fsys, clear.reports = TRUE)

# Run report generation pipe
epitrax <- setup_epitrax(
    filepath = data_fp,
    config_file = config_file,
    disease_list_files = disease_lists
  ) |>
  epitrax_ireport_annual_counts() |>
  epitrax_ireport_monthly_counts_all_yrs() |>
  epitrax_ireport_monthly_avgs() |>
  epitrax_ireport_ytd_counts_for_month() |>
  epitrax_preport_month_crosssections() |>
  epitrax_preport_ytd_rates() |>
  epitrax_write_csvs(fsys = fsys)

length(epitrax$internal_reports)
list.files(fsys$internal)

length(epitrax$public_reports)
list.files(fsys$public)

## ----cleanup2, include = FALSE------------------------------------------------
unlink(unlist(fsys, use.names = FALSE), recursive = TRUE)

