% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_stats_per_period.R
\name{do_stats_per_period}
\alias{do_stats_per_period}
\title{Compute stats per period}
\usage{
do_stats_per_period(data, day_num, game_code, team_sel, period_sel, player_sel)
}
\arguments{
\item{data}{Prepared data from a given game.}

\item{day_num}{Day number.}

\item{game_code}{Game code.}

\item{team_sel}{One of the teams' names involved in the game.}

\item{period_sel}{Period of interest. Options can be "xC", where x=1,2,3,4.}

\item{player_sel}{Player of interest.}
}
\value{
Data frame with one row and mainly time played (seconds and minutes) and points
scored by the player of interest in the period of interest.
}
\description{
Compute time played and points scored for a player of interest in any period
of the game.
}
\note{
The \strong{game_code} column allows us to detect the source website, for example,
\url{https://live.acb.com/es/partidos/103389/jugadas}.
}
\examples{
day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

team_sel <- "Valencia Basket"
period_sel <- "1C"
player_sel <- "Webb" 
 
pre_per <- do_preproc_period(acb_vbc_cz_pbp_2223, team_sel, period_sel, acb_vbc_cz_sl_2223)
 
df2 <- pre_per$df2
df0_inli_team <- pre_per$df0_inli_team
 
df3 <- do_prepare_data(df2, day_num, 
                       df0_inli_team, acb_games_2223_info,
                       game_code)
                        
df4 <- do_stats_per_period(df3, day_num, game_code, team_sel, period_sel, player_sel)
#df4

}
\author{
Guillermo Vinue
}
