% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_interface_latentattrition.R
\name{latentAttrition}
\alias{latentAttrition}
\title{Formula Interface for Latent Attrition Models}
\usage{
latentAttrition(
  formula,
  family,
  data,
  optimx.args = list(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{formula}{Formula to select and transform covariates in \code{data}. Has to be left empty if \code{data} contains no covariates. See Details.}

\item{family}{A latentAttrition model. One of \code{pnbd},  \code{bgnbd}, or \code{ggomnbd}.}

\item{data}{A \code{clv.data} object.}

\item{optimx.args}{Additional arguments to control the optimization which are forwarded to \code{\link[optimx:optimx]{optimx::optimx}}.
If multiple optimization methods are specified, only the result of the last method is further processed.}

\item{verbose}{Show details about the running of the function.}

\item{...}{Forwarded to model specified in \code{family}.}
}
\description{
Fit latent attrition models for transaction behavior, using a formula to specify the covariates.
}
\details{
A two-part formula is used to select and transform the covariates stored in \code{data} before the model is estimated on it.
May not be given if \code{data} contains no covariates.

The formula left hand side (LHS) has to remain empty and may never be specified.

The formula right hand side (RHS) follows a two-part notation using \code{|} as separator.
\itemize{
\item 1st part: Which covariates to include for the lifetime process, potentially transforming them and adding interactions. The dot ('.') refers to all lifetime covariates.
\item 2nd part: Which covariates to include for the transaction process, potentially transforming them and adding interactions. The dot ('.') refers to all transaction covariates
}

e.g: \code{ ~ covlife | covtrans}

See the example section for illustrations on how to specify the formula parameter.
}
\examples{
\donttest{

data("apparelTrans")
data("apparelStaticCov")

clv.nocov <-
    clvdata(apparelTrans, time.unit="w", date.format="ymd")

# Create static covariate data with 2 covariates
clv.staticcov  <-
  SetStaticCovariates(clv.nocov,
                      data.cov.life  = apparelStaticCov,
                      names.cov.life = c("Gender", "Channel"),
                      data.cov.trans = apparelStaticCov,
                      names.cov.trans = c("Gender", "Channel"))

# Fit models without covariates.
# Note that NO formula may be specified in this case
latentAttrition(formula =, family=pnbd, data=clv.nocov)
latentAttrition(formula =, family=bgnbd, data=clv.nocov)
latentAttrition(formula =, family=ggomnbd, data=clv.nocov)

# Fit pnbd with start parameters and correlation
# required args are passed as part of '...'
latentAttrition(formula =, family=pnbd, data=clv.nocov,
                use.cor=TRUE,
                start.params.model=c(r=1, alpha=10, s=2, beta=8))


# Fit pnbd with all present covariates
latentAttrition(formula=~.|., family=pnbd, data=clv.staticcov)

# Fit pnbd with selected covariates
latentAttrition(formula=~Gender|Channel+Gender, family=pnbd,
                data=clv.staticcov)

# Fit pnbd with start parameters for covariates
latentAttrition(formula=~Gender|., family=pnbd,
                data=clv.staticcov,
                start.params.life = c(Gender = 0.6),
                start.params.trans = c(Gender = 0.6, Channel = 0.4))

# Fit pnbd with transformed covariate data
latentAttrition(formula=~Gender|I(log(Channel+2)), family=pnbd,
                data=clv.staticcov)

# Fit pnbd with all covs and regularization
latentAttrition(formula=~.|., family=pnbd, data=clv.staticcov,
                reg.lambdas = c(life=3, trans=8))

# Fit pnbd with all covs and constraint parameters for Channel
latentAttrition(formula=~.|., family=pnbd, data=clv.staticcov,
                names.cov.constr='Channel')

}


}
\seealso{
Models for inputs to family: \link{pnbd}, \link{ggomnbd}, \link{bgnbd}.

\link{spending} to fit spending models with a formula interface
}
