% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_set_theme_dalex.R
\name{set_theme_dalex}
\alias{set_theme_dalex}
\alias{theme_default_dalex}
\alias{theme_vertical_default_dalex}
\title{Default Theme for DALEX plots}
\usage{
set_theme_dalex(
  default_theme = "drwhy",
  default_theme_vertical = default_theme
)

theme_default_dalex()

theme_vertical_default_dalex()
}
\arguments{
\item{default_theme}{object - string ("drwhy" or "ema") or an object of ggplot theme class. Will be applied by default by DALEX to all horizontal plots}

\item{default_theme_vertical}{object - string ("drwhy" or "ema") or an object of ggplot theme class. Will be applied by default by DALEX to all vertical plots}
}
\value{
list with current default themes
}
\description{
Default Theme for DALEX plots
}
\examples{
old <- set_theme_dalex("ema")
\donttest{
library("ranger")
apartments_ranger_model <- ranger(m2.price~., data = apartments, num.trees = 50)
explainer_ranger  <- explain(apartments_ranger_model, data = apartments[,-1],
                             y = apartments$m2.price, label = "Ranger Apartments")
model_parts_ranger_aps <- model_parts(explainer_ranger, type = "raw")
head(model_parts_ranger_aps, 8)
plot(model_parts_ranger_aps)

old <- set_theme_dalex(ggplot2::theme_void(), ggplot2::theme_void())
plot(model_parts_ranger_aps)

old <- set_theme_dalex("drwhy")
plot(model_parts_ranger_aps)
old <- set_theme_dalex(ggplot2::theme_void(), ggplot2::theme_void())
plot(model_parts_ranger_aps)
}

}
