#' REVEL data set
#'
#' A reconstructed survival data set for the REVEL clinical trial
#'
#' @format A data frame with 625 rows and 2 variables:
#' \describe{
#'   \item{Survival time}{Survival Time (in months)}
#'   \item{Status}{Event indicator (0=Alive, 1=Dead)}
#' }
#' @source Reconstructed survival data set from the following publication: https://www.thelancet.com/journals/lancet/article/PIIS0140-6736(14)60845-X/fulltext
"REVEL"

#' INTEREST data set
#'
#' A reconstructed survival data set for the INTEREST clinical trial
#'
#' @format A data frame with 710 rows and 2 variables:
#' \describe{
#'   \item{Survival time}{Survival Time (in months)}
#'   \item{Status}{Event indicator (0=Alive, 1=Dead)}
#' }
#' @source Reconstructed survival data set from the following publication: https://www.sciencedirect.com/science/article/pii/S0140673608617584?via%3Dihub
"INTEREST"

#' ZODIAC data set
#'
#' A reconstructed survival data set for the ZODIAC clinical trial
#'
#' @format A data frame with 697 rows and 2 variables:
#' \describe{
#'   \item{Survival time}{Survival Time (in months)}
#'   \item{Status}{Event indicator (0=Alive, 1=Dead)}
#' }
#' @source Reconstructed survival data set from the following publication: https://www.sciencedirect.com/science/article/abs/pii/S1470204510701327?via%3Dihub
"ZODIAC"


#' MCMC_sample
#'
#' An MCMC sample for the example given in Salsbury et al (2024)
#'
#' @format A data frame with 100000 rows and 1 variables:
#' \describe{
#'   \item{x}{Sample from the MAP prior}
#'
#' }
#' @source A MCMC sample for the control group for the example given in https://onlinelibrary.wiley.com/doi/full/10.1002/sim.10136.
#' Three historical data seta are used to generate a Meta-Analytic-Predictive Prior distribution
"MCMC_sample"




