% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{voting_dia}
\alias{voting_dia}
\title{Train a Voting Ensemble Diagnostic Model}
\usage{
voting_dia(
  results_all_models,
  data,
  type = c("soft", "hard"),
  weight_metric = "AUROC",
  top = 5,
  seed = 789,
  threshold_choices = "f1",
  positive_label_value = 1,
  negative_label_value = 0,
  new_positive_label = "Positive",
  new_negative_label = "Negative"
)
}
\arguments{
\item{results_all_models}{A list of results from \code{models_dia()},
containing trained base model objects and their evaluation metrics.}

\item{data}{A data frame where the first column is the sample ID, the second
is the outcome label, and subsequent columns are features. Used for evaluation.}

\item{type}{A character string, "soft" for weighted average of probabilities
or "hard" for majority class voting.}

\item{weight_metric}{A character string, the metric to use for weighting
base models in soft voting (e.g., "AUROC", "F1"). Ignored for hard voting.}

\item{top}{An integer, the number of top-performing base models (ranked by
\code{weight_metric}) to include in the ensemble.}

\item{seed}{An integer, for reproducibility.}

\item{threshold_choices}{A character string (e.g., "f1", "youden", "default")
or a numeric value (0-1) for determining the evaluation threshold for the ensemble.}

\item{positive_label_value}{A numeric or character value in the raw data
representing the positive class.}

\item{negative_label_value}{A numeric or character value in the raw data
representing the negative class.}

\item{new_positive_label}{A character string, the desired factor level name
for the positive class (e.g., "Positive").}

\item{new_negative_label}{A character string, the desired factor level name
for the negative class (e.g., "Negative").}
}
\value{
A list containing the \code{model_object}, \code{sample_score}, and \code{evaluation_metrics}.
}
\description{
Implements a Voting ensemble, combining predictions from multiple
base models through soft or hard voting.
}
\examples{
\donttest{
# 1. Initialize the modeling system
initialize_modeling_system_dia()

# 2. Create a toy dataset for demonstration
set.seed(42)
data_toy <- data.frame(
  ID = paste0("Sample", 1:60),
  Status = sample(c(0, 1), 60, replace = TRUE),
  Feat1 = rnorm(60),
  Feat2 = runif(60)
)

# 3. Generate mock base model results (as if from models_dia)
base_model_results <- models_dia(
  data = data_toy,
  model = c("rf", "lasso"),
  seed = 123
)

# 4. Run the soft voting ensemble
soft_voting_results <- voting_dia(
  results_all_models = base_model_results,
  data = data_toy,
  type = "soft",
  weight_metric = "AUROC",
  top = 2,
  threshold_choices = "f1"
)
print_model_summary_dia("Soft Voting", soft_voting_results)
}
}
\seealso{
\code{\link{models_dia}}, \code{\link{evaluate_model_dia}}
}
