% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_onepoint.R
\name{recombination_onepoint}
\alias{recombination_onepoint}
\title{One-point recombination for DE}
\usage{
recombination_onepoint(X, M, recpars = list(K = NULL))
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the one-point recombination (as used in the Simple GA).
}
\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_onepoint()} understands the following 
fields in \code{recpars}:
\itemize{
   \item \code{K} : cut point for crossover.\cr
   Accepts integer value \code{0 <= K < n}, where \code{n} is the 
   dimension of the problem; Use \code{K = 0} or \code{K = NULL} for randomly 
   choosing a position for each pair of points.\cr
   Defaults to \code{NULL}.
}
}

\section{References}{

F. Herrera, M. Lozano, A. M. Sanchez, "A taxonomy for the crossover
operator for real-coded genetic algorithms: an experimental study", 
International Journal of Intelligent Systems 18(3) 309-338, 2003.
}

