% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{iscamnormprob}
\alias{iscamnormprob}
\title{Normal Tail Probability}
\usage{
iscamnormprob(
  xval,
  mean = 0,
  sd = 1,
  direction,
  label = NULL,
  xval2 = NULL,
  digits = 4,
  verbose = TRUE
)
}
\arguments{
\item{xval}{observed value.}

\item{mean}{mean of normal distribution.}

\item{sd}{standard deviation of normal distribution.}

\item{direction}{direction for probability calculation, "above" or "below"; if
"outside" or "between" are used, a second larger observation, \code{xval2} must be
specified}

\item{label}{horizontal axis label.}

\item{xval2}{second observation value.}

\item{digits}{number of digits to display.}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
a p-value and a plot of the normal distribution with shaded area
representing probability of the observed value or more extreme occurring.
}
\description{
\code{normprob} finds a p-value and plots it onto a normal distribution with mean
and standard deviation as specified. The function can find the probability
above, below, between, or outside of the observed value, as specified by
\code{directions}.
}
\examples{
iscamnormprob(1.96, direction = "above")
iscamnormprob(-1.5, mean = 1, sd = 2, direction = "below")
iscamnormprob(0, xval2 = 1.5, direction = "between")
iscamnormprob(-1, xval2 = 1, direction = "outside")
}
