% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{iscamonepropztest}
\alias{iscamonepropztest}
\title{One Proportion Z-Test and Interval}
\usage{
iscamonepropztest(
  observed,
  n,
  hypothesized = NULL,
  alternative = "two.sided",
  conf.level = NULL,
  verbose = TRUE
)
}
\arguments{
\item{observed}{The observed number of successes. If a value less than 1 is
provided, it is assumed to be the sample proportion.}

\item{n}{The sample size.}

\item{hypothesized}{The hypothesized probability of success under the null
hypothesis. This is an optional parameter.}

\item{alternative}{A character string specifying the form of the alternative
hypothesis. Must be one of "less", "greater", or "two.sided". This is
an optional parameter.}

\item{conf.level}{The confidence level(s) for a two-sided confidence
interval. This is an optional parameter.}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
This function prints the results of the one-proportion z-test and/or
the confidence interval. It also generates plots to visualize the test and
interval.
}
\description{
iscamonepropztest calculates a one-proportion z-test and/or a corresponding
confidence interval.
}
\examples{
iscamonepropztest(observed = 35, n = 50, hypothesized = 0.5)

iscamonepropztest(
  observed = 0.8,
  n = 100,
  hypothesized = 0.75,
  alternative = "greater",
  conf.level = 0.95
)

iscamonepropztest(observed = 60, n = 100, conf.level = 0.90)
}
