% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAFLD.R
\name{MAFLD}
\alias{MAFLD}
\title{Diagnosis of Metabolic Dysfunction Associated Fatty Liver Disease}
\usage{
MAFLD(x)
}
\arguments{
\item{x}{a data frame with column names as exactly specified.}
}
\value{
Yes or No
}
\description{
The latest guidelines proposed by International Expert Consensus are used widely for the clinical diagnosis of Metabolic Associated Fatty Liver Disease (MAFLD). The new definition takes hepatic steatosis (determined by elastography or histology or biomarker-based fatty liver index) as a major criterion. In addition, race, gender, body mass index (BMI), waist circumference (WC), fasting plasma glucose (FPG), systolic blood pressure (SBP), diastolic blood pressure (DBP), triglycerides (TG), high-density lipoprotein cholesterol (HDLC), homeostatic model assessment of insulin resistance (HOMAIR), high sensitive c-reactive protein (HsCRP) for the diagnosis of MAFLD. Each parameter has to be interpreted based on the proposed cut-offs, making the diagnosis slightly complex and error-prone. This package is developed by incorporating the latest international expert consensus guidelines, and it will aid in the easy and quick diagnosis of MAFLD based on FibroScan in busy healthcare settings and also for research purposes. The new definition for MAFLD as per the International Consensus Statement is described by Eslam M et al (2020). <doi:10.1016/j.jhep.2020.03.039>.
}
\examples{
MAFLD(x)
}
