% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_prop.R
\name{d_prop}
\alias{d_prop}
\alias{d.prop}
\title{Cohen's d (SMD) for Independent Proportions (Binary Outcomes)}
\usage{
d_prop(p1, p2, n1, n2, a = 0.05)

d.prop(p1, p2, n1, n2, a = 0.05)
}
\arguments{
\item{p1}{Proportion for group one (between 0 and 1).}

\item{p2}{Proportion for group two (between 0 and 1).}

\item{n1}{Sample size for group one.}

\item{n2}{Sample size for group two.}

\item{a}{Significance level used for confidence intervals. Defaults to 0.05.}
}
\value{
A list with the same structure as [d_ind_t()], containing the standardized
mean difference and its confidence interval, along with auxiliary
statistics. The list is augmented with explicit entries `p1`, `p2`,
`p1_value`, and `p2_value` to emphasize that the original inputs were
proportions.
}
\description{
This function computes a standardized mean difference effect size for two
independent proportions by treating each as the mean of a Bernoulli
(0/1) variable and computing a standardized mean difference (SMD)
directly using the pooled Bernoulli standard deviation. This follows
the same logic as Cohen's d for continuous variables, but applied to
binary outcomes:
}
\details{
\deqn{d = \frac{p_1 - p_2}{s_{\mathrm{pooled}}}}

where

\deqn{s_{\mathrm{pooled}} = \sqrt{\frac{(n_1 - 1)p_1(1 - p_1) +
                                     (n_2 - 1)p_2(1 - p_2)}
                                     {n_1 + n_2 - 2}}}

This replaces the original z‐based formulation used in older versions
of MOTE. The SMD effect size is directly comparable to all other d‐type
effect sizes in the package.
}
\examples{
d_prop(p1 = .25, p2 = .35, n1 = 100, n2 = 100, a = .05)
}
