% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_userfit_nuisance.R
\name{mcee_userfit_nuisance}
\alias{mcee_userfit_nuisance}
\title{Mediated Causal Excursion Effects with user-supplied nuisance predictions}
\usage{
mcee_userfit_nuisance(
  data,
  id,
  dp,
  outcome,
  treatment,
  mediator,
  availability = NULL,
  time_varying_effect_form,
  p1,
  q1,
  eta1,
  eta0,
  mu1,
  mu0,
  nu1,
  nu0,
  weight_per_row = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data.frame in long format (one row per id-by-decision point).}

\item{id}{Character. Column name for subject identifier.}

\item{dp}{Character. Column name for decision point index (must increase strictly within subject).}

\item{outcome}{Character. Column name for distal outcome (constant within subject).}

\item{treatment}{Character. Column name for treatment (coded 0/1).}

\item{mediator}{Character. Column name for mediator.}

\item{availability}{Optional character. Column name for availability (0/1). If \code{NULL}, all rows are treated as available.}

\item{time_varying_effect_form}{RHS-only formula for the basis \eqn{f(t)} (e.g., \code{~ 1}, \code{~ dp}, \code{~ poly(dp,2)}).}

\item{p1, q1, eta1, eta0, mu1, mu0, nu1, nu0}{Numeric vectors (or column names) of
per-row predictions aligned with \code{data}. See Details for definitions.}

\item{weight_per_row}{Optional numeric vector of row weights (nonnegative, length \code{nrow(data)}). If \code{NULL}, uniform within-id weights are used.}

\item{verbose}{Logical; print progress messages.}
}
\value{
An \code{"mcee_fit"} object; see \code{\link{mcee}}.
}
\description{
Skips Stage-1 model fitting and uses user-provided nuisance predictions.
}
\details{
Nuisance definitions:
\itemize{
  \item \code{p1}: \eqn{P(A_t=1\mid H_t)} (known in MRTs). (Technically,
  this is \eqn{P(A_t=I_t\mid H_t)}, but the user is allowed to input \eqn{P(A_t=1\mid H_t)}
  and the function will automatically correct it by setting \code{p1 = 1} when \eqn{I_t = 0}.)
  \item \code{q1}: \eqn{P(A_t=1\mid H_t, M_t)}. (Technically,
  this is \eqn{P(A_t=I_t\mid H_t, M_t)}, but the user is allowed to input \eqn{P(A_t=1\mid H_t, M_t)}
  and the function will automatically correct it by setting \code{q1 = 1} when \eqn{I_t = 0}.)
  \item \code{eta1}, \code{eta0}: \eqn{E(Y\mid H_t, A_t=1)} and \eqn{E(Y\mid H_t, A_t=0)}.
  \item \code{mu1}, \code{mu0}: \eqn{E(Y\mid H_t, A_t=1, M_t)} and \eqn{E(Y\mid H_t, A_t=0, M_t)}.
  \item \code{nu1}, \code{nu0}: cross-world regressions; see vignette and paper for definitions.
}
If \code{availability} is provided, rows with \eqn{I=0} are coerced to \code{p1=q1=1}
(and hence \code{p0=q0=1}); a warning is emitted if overrides occur.
}
\examples{
set.seed(1)
n <- 10
T <- 4
id <- rep(1:n, each = T)
dp <- rep(1:T, times = n)
A <- rbinom(n * T, 1, 0.5)
M <- rbinom(n * T, 1, plogis(-0.2 + 0.3 * A + 0.1 * dp))
Y <- ave(0.5 * A + 0.6 * M + 0.1 * dp + rnorm(n * T), id)
dat <- data.frame(id, dp, A, M, Y)

fit_usr <- mcee_userfit_nuisance(dat, "id","dp","Y","A","M",
    time_varying_effect_form = ~ dp,
    p1 = rep(0.5, nrow(dat)),
    q1 = runif(nrow(dat),.3,.7),
    eta1 = rnorm(nrow(dat)), eta0 = rnorm(nrow(dat)),
    mu1 = rnorm(nrow(dat)),  mu0 = rnorm(nrow(dat)),
    nu1 = rnorm(nrow(dat)),  nu0 = rnorm(nrow(dat)))
}
\seealso{
\code{\link{mcee}}, \code{\link{mcee_general}}
}
