% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_MSU_c.R
\name{scale_color_msu_c}
\alias{scale_color_msu_c}
\title{Plotting with MSU palettes for colour ggplot2}
\usage{
scale_color_msu_c(palette, direction = 1, ...)
}
\arguments{
\item{palette}{name of palette. Run \code{names(MSUpalettes)} to view options.}

\item{direction}{Sets order of colors. Default palette_choice is 1. If direction is -1,
palette_choice color order is reversed}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{scale_color_gradientn}}}
}
\value{
A ggproto object defining a continuous colour scale for use with ggplot2.
}
\description{
Plotting with MSU palettes for colour ggplot2
}
\examples{
library(ggplot2)
ggplot(data = mtcars, aes(x = mpg, y = disp, color = wt)) +
  geom_point() +
  scale_color_msu_c(palette = "msu_seq")
}
