% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{read_dsv_formatted}
\alias{read_dsv_formatted}
\title{Read delimiter (tab/comma) separated values file correctly formatted}
\usage{
read_dsv_formatted(file, dd, action = "warn")
}
\arguments{
\item{file}{character. Path to the \code{.tsv} or \code{.csv} file.}

\item{dd}{tibble. Data dictionary specifying the column types. Only columns
specified in the data dictionary are read.}

\item{action}{character. What to do if there are columns in the file that are
not specified in the data dictionary (One of \code{"warn"}, \code{"error"}, or
\code{"ignore"}; default: \code{"warn"}).}
}
\value{
A tibble with the data/shadow matrix read from the \code{.tsv}
or \code{.csv} file.
}
\description{
Reads in a \code{.tsv} or \code{.csv} file with correctly formatted column types.
Uses \code{\link[readr:read_delim]{readr::read_tsv()}}/\code{\link[readr:read_delim]{readr::read_csv()}} internally and specifies the
column types explicitly using the \code{col_types} argument utilizing information
from the data dictionary. Returns only the identifier columns and the columns
specified in the data dictionary, i.e., all columns in the file that are not
specified in the data dictionary are ignored.
}
\details{
\emph{\strong{WHY THIS IS IMPORTANT:}} \code{readr::read_tsv()}/\code{readr::read_csv()} (like
other commands to load text files in R or other programming languages) by
default infers the column types from the data. This doesn't always work
perfectly. For example, it may interpret a column with only integers as a
double, or a column with only dates as a character. Sometimes a column may
even be read in completely empty because, by default,
\code{readr::read_tsv()}/\code{readr::read_csv()} only considers the first 1000 rows
when inferring the data type and interprets the column as an empty logical
vector if those rows are all empty. The NBDC datasets store categorical
data as integers formatted as character. By default,
\code{readr::read_tsv()}/\code{readr::read_csv()} may interpret them as numeric. By
specifying the column types explicitly based on what is defined in the
data dictionary, we can avoid these issues.

\emph{\strong{GENERAL RECOMMENDATION:}} Other file formats like \code{.parquet} correctly
store the column types and don't need to be handled explicitly. They also
offer other advantages like faster reading speed and smaller file sizes. As
such, these formats should generally be preferred over \code{.tsv}/\code{.csv} files.
However, if you have to work with \code{.tsv}/\code{.csv} files, this function can help
you avoid common pitfalls.
}
\examples{
\dontrun{
dd <- NBDCtools::get_dd("abcd", "6.0")
read_tsv_formatted("path/to/file.tsv", dd)
}
}
