% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxEarthDist.R
\name{maxEarthDist}
\alias{maxEarthDist}
\title{maximum distance between set of points}
\usage{
maxEarthDist(
  lat,
  long,
  data,
  r = 6371,
  fun = max,
  each = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{lat, long, data}{Coordinates for \code{\link{earthDist}}}

\item{r}{Earth Radius for \code{\link{earthDist}}}

\item{fun}{Function to be applied. DEFAULT: \code{\link{max}}}

\item{each}{Logical: give max dist to all other points for each point separately?
If FALSE, will return the maximum of the complete distance matrix,
as if \code{max(maxEarthDist(y,x))}. DEFAULT: TRUE}

\item{quiet}{Logical: suppress non-df warning in \code{\link[berryFunctions]{getColumn}}? 
DEFAULT: FALSE}

\item{\dots}{Further arguments passed to fun, like na.rm=TRUE}
}
\value{
Single number
}
\description{
Maximum great-circle distance between points at lat-long coordinates.
This is not computationally efficient.
For large datasets, consider pages like \url{https://stackoverflow.com/a/16870359}.
}
\examples{

d <- read.table(header=TRUE, text="
    x     y
14.9 53.73
1.12 53.12
6.55 58.13
7.71 71.44
")

plot(d, asp=1, pch=as.character(1:4), xlab="lon", ylab="lat")
for(i in 1:4) segments(d$x[-i], d$y[-i], d$x[i], d$y[i], col=2)
text(x=c(7,10,11), y=c(53,56,64), round(earthDist(y,x,d    )[-1]),  col=2)
text(x=c(4,4),     y=c(56,61),    round(earthDist(y,x,d,i=2)[3:4]), col=2)
text(x=7,          y=64,          round(earthDist(y,x,d,i=4)[3]),   col=2)

round(  earthDist(y,x,d, i=2)   )
round(  earthDist(y,x,d, i=3)   )

round(  maxEarthDist(y,x,d)              )
round(  maxEarthDist(y,x,d, each=FALSE)  )
round(  maxEarthDist(y,x,d, fun=min)     )

maxEarthDist(y,x, d[1:2,] )

}
\seealso{
\code{\link{earthDist}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2017
}
\keyword{spatial}
