% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_color.R
\name{olink_color_gradient}
\alias{olink_color_gradient}
\title{Olink color scale for continuous ggplots}
\usage{
olink_color_gradient(..., alpha = 1, coloroption = NULL)
}
\arguments{
\item{...}{Optional. Additional arguments to pass to scale_color_gradientn()}

\item{alpha}{transparency (optional)}

\item{coloroption}{string, one or more of the following:
c('red', 'orange', 'yellow', 'green', 'teal', 'turqoise', 'lightblue', 'darkblue', 'purple', 'pink')}
}
\value{
No return value, called for side effects
}
\description{
Olink color scale for continuous ggplots
}
\examples{

library(ggplot2)

dsub <- subset(diamonds, x > 5 & x < 6 & y > 5 & y < 6)
dsub$diff <- with(dsub, sqrt(abs(x-y))* sign(x-y))

ggplot(dsub, aes(x, y, colour=diff)) +
geom_point() +
 theme_bw() +
 olink_color_gradient()

}
