% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCBN-object.R
\name{new_PCBN}
\alias{new_PCBN}
\title{Initializes PCBN class}
\usage{
new_PCBN(DAG, order_hash, copula_mat, verbose = 0)
}
\arguments{
\item{DAG}{the corresponding DAG (a `bn` object)}

\item{order_hash}{a hashmap of character vectors
Each character vector corresponds
to the order of the parents for the given node.}

\item{copula_mat}{a list with at least two components: \itemize{
  \item \code{fam} the matrix of families
  \item \code{tau} the matrix of Kendall's tau
}
They both should be matrices of size \code{d * d},
where \code{d} is the number of nodes in the graph \code{DAG}.}

\item{verbose}{If \code{0}, no message is printed.
If \code{1} (recommended),
information is printed during the checking of the PCBN.}
}
\value{
the new PCBN
}
\description{
Initializes PCBN class
}
\examples{
DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

fam = matrix(c(0, 0, 1,
               0, 0, 1,
               0, 0, 0), byrow = TRUE, ncol = 3)
tau = 0.2 * fam

my_PCBN = new_PCBN(
  DAG, order_hash,
  copula_mat = list(tau = tau, fam = fam))

}
