% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGBOAlgorithm.R
\name{PGBOAlgorithm}
\alias{PGBOAlgorithm}
\title{PGBOAlgorithm}
\usage{
PGBOAlgorithm(
  name = character(0),
  modelEquations = list(),
  modelFromLibrary = list(),
  modelParameters = list(),
  modelError = list(),
  optimizer = character(0),
  optimizerParameters = list(),
  outputs = list(),
  designs = list(),
  fimType = character(0),
  fim = Fim(),
  odeSolverParameters = list(),
  optimisationDesign = list(),
  optimisationAlgorithmOutputs = list(),
  N = numeric(0),
  muteEffect = numeric(0),
  maxIteration = numeric(0),
  purgeIteration = numeric(0),
  seed = numeric(0),
  showProcess = FALSE
)
}
\arguments{
\item{name}{A string giving the name of the design evaluation.}

\item{modelEquations}{A list giving the model equations.}

\item{modelFromLibrary}{A list giving the model equations from the library of model.}

\item{modelParameters}{A list giving the model parameters.}

\item{modelError}{A list giving the model error.}

\item{optimizer}{A string giving the name of the optimization algorithm being used.}

\item{optimizerParameters}{A list giving the parameters of the optimization algorithm.}

\item{outputs}{A list giving the model outputs.}

\item{designs}{A list giving the designs to be evaluated.}

\item{fimType}{A string giving the type of Fim being evaluated.}

\item{fim}{A object \code{Fim} giving the Fim.}

\item{odeSolverParameters}{A list giving the atol and rtol parameters for the ode solver.}

\item{optimisationDesign}{A list giving the evaluation of initial and optimal design.}

\item{optimisationAlgorithmOutputs}{A list giving the outputs of the optimization process.}

\item{N}{A numeric giving the parameter N.}

\item{muteEffect}{A numeric giving the parameter muteEffect.}

\item{maxIteration}{A numeric giving the parameter maxIteration.}

\item{purgeIteration}{A numeric giving the parameter purgeIteration.}

\item{seed}{A numeric giving the parameter seed.}

\item{showProcess}{A Boolean giving showProcess.}
}
\description{
The class \code{PGBOAlgorithm} implements the PGBO algorithm.
}
