% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A03-bootstrap-variance.R
\name{var_surv_weibull_bootstrap}
\alias{var_surv_weibull_bootstrap}
\title{Bootstrap Variance Estimation for Weibull Survival Functions}
\usage{
var_surv_weibull_bootstrap(
  data,
  surv_result,
  treatment_var,
  time_var,
  event_var,
  censoring_formula,
  censoring_control = list(maxiter = 350),
  B = 100,
  parallel = FALSE,
  mc.cores = 2,
  seed = NULL,
  boot_level = "full"
)
}
\arguments{
\item{data}{Data frame used in original \code{surv_weibull()} call.}

\item{surv_result}{Output from \code{surv_weibull()}.}

\item{treatment_var}{Name of treatment variable.}

\item{time_var}{Name of time variable.}

\item{event_var}{Name of event indicator variable.}

\item{censoring_formula}{Formula for censoring score model.}

\item{censoring_control}{Control parameters for \code{survreg()}.
Default \code{list(maxiter = 350)}.}

\item{B}{Number of bootstrap iterations. Default 100.}

\item{parallel}{Logical. If TRUE, use parallel computation via \code{mclapply}.
Default FALSE.}

\item{mc.cores}{Number of cores for parallel computation. Default 2.}

\item{seed}{Optional random seed for reproducibility. Ensures identical results
across runs and between sequential and parallel execution. Default NULL.}

\item{boot_level}{Bootstrap sampling level: "full" (default) or "strata".
"full" resamples from entire dataset (observational studies). "strata"
resamples within treatment groups preserving group sizes (RCTs).}
}
\value{
List containing:
  \item{var_matrix}{Matrix [time x group] of bootstrap variances.}
  \item{se_matrix}{Matrix [time x group] of bootstrap standard errors.}
  \item{boot_samples}{List of length B with survival matrices from each iteration.}
  \item{boot_allocation}{Matrix [B x group] of sample sizes for each group in each bootstrap iteration.}
  \item{n_success_by_group}{Matrix [time x group] of successful iterations.}
  \item{n_failed_by_group}{Matrix [time x group] of failed iterations.}
  \item{B}{Total bootstrap iterations.}
}
\description{
Estimates bootstrap variance for counterfactual survival functions from
\code{surv_weibull()}. Supports binary and multiple treatment groups.
}
\details{
Each bootstrap iteration resamples observations with replacement and re-estimates
propensity scores, weights, and survival functions using the same specifications
as the original analysis. Treatment groups may fail independently if not sampled
or if models fail to converge.
}
\keyword{internal}
