% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Forest_seg.R
\name{Forest_seg}
\alias{Forest_seg}
\title{Forest component segmentation}
\usage{
Forest_seg(
  a,
  filename = "XXX",
  dimVox = 2,
  th = 2,
  eps = 2,
  mpts = 9,
  h_tree = 1,
  soil_dim = 0.1,
  N = 500,
  R = 30,
  Vox_print = FALSE,
  WoodVox_print = FALSE,
  output_path = tempdir(),
  analyze_canopy = TRUE,
  canopy_voxel_size = 0.1,
  min_canopy_height = 1.5,
  coverage_method = "mean_normalized"
)
}
\arguments{
\item{a}{Input point cloud data frame (.xyz) or file path}

\item{filename}{Output file prefix}

\item{dimVox}{Voxel dimension (cm) for wood segmentation (default = 2)}

\item{th}{Minimum number of points to generate a voxel (default = 2)}

\item{eps}{Epsilon neighborhood radius for DBSCAN (default = 2)}

\item{mpts}{Minimum points required in eps neighborhood for core points (default = 9)}

\item{h_tree}{Minimum trunk length in meters (default = 1)}

\item{soil_dim}{Voxel dimension (m) for forest floor segmentation (default = 0.1)}

\item{N}{Minimum number of voxels in a wood cluster (default = 500)}

\item{R}{Cluster shape parameter threshold (default = 30)}

\item{Vox_print}{Logical; if TRUE, saves point cloud voxelization (default = FALSE)}

\item{WoodVox_print}{Logical; if TRUE, saves wood voxelization (default = FALSE)}

\item{output_path}{Output directory (default = tempdir())}

\item{analyze_canopy}{Logical; if TRUE, performs canopy analysis (default = TRUE)}

\item{canopy_voxel_size}{Voxel size for canopy analysis in meters (default = 0.1)}

\item{min_canopy_height}{Minimum height threshold for canopy analysis (default = 1.5)}

\item{coverage_method}{Method for calculating coverage degree (default = "mean_normalized")}
}
\value{
List containing file paths and metrics for trees and canopy.
}
\description{
Segments an input .xyz point cloud file into different forestry layers (soil, wood, foliage), computes individual tree metrics, and provides summary statistics and canopy metrics.
}
