% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_selection}
\alias{as_selection}
\title{Convert Conditions to Selection Format}
\usage{
as_selection(condition_matrix, date_column = NULL)
}
\arguments{
\item{condition_matrix}{Matrix or data frame with conditions}

\item{date_column}{Optional Date vector if not in input}
}
\value{
Data.table in selection format (Date + binary columns)
}
\description{
Converts condition matrices or data frames to standard selection format
with Date column and binary values. Handles NA by converting to 0.
}
\examples{
data("sample_prices_weekly")
ma20 <- calc_moving_average(sample_prices_weekly, 20)
above_ma <- filter_above(calc_distance(sample_prices_weekly, ma20), 0)
selection <- as_selection(above_ma, sample_prices_weekly$Date)
}
