% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_prediction.R
\name{prediction}
\alias{prediction}
\title{prediction object constructor.}
\usage{
prediction(
  X,
  spagFiles,
  data.dir = getwd(),
  data.fnames = paste0("X", 1:length(X), ".pred"),
  fname = paste0("Config_Pred_", paste0(sample(c(letters, LETTERS, 0:9), 6), collapse =
    ""), ".txt"),
  doParametric = FALSE,
  doStructural = rep(FALSE, length(spagFiles)),
  transposeSpag = TRUE,
  priorNsim = NULL,
  envFiles = paste0(tools::file_path_sans_ext(spagFiles), ".env"),
  consoleProgress = TRUE,
  spagFiles_state = NULL,
  transposeSpag_state = TRUE,
  envFiles_state = switch(is.null(spagFiles_state) + 1,
    paste0(tools::file_path_sans_ext(spagFiles_state), ".env"), NULL),
  parSamples = NULL
)
}
\arguments{
\item{X}{data frame or list of dataframes / matrices, representing the
values taken by the input variables.
\itemize{
  \item If X is a dataframe, then each column is interpreted as one input variable, and consequently
  inputs are not replicated (=> no input uncertainty).
  \item If X is a list, then each element of the list is a matrix associated with one input variable, and
  the columns of this matrix are replications (=> input uncertainty is propagated). All matrices
  in the list should have the same number of rows, columns are recycled if needed.
}}

\item{spagFiles}{Character vector (size nY, the number of output variables). Name of the files containing the spaghettis
for each output variable. NOTE: provide file names only, not full paths.
Using a '.spag' extension is a good practice.}

\item{data.dir}{Character, directory where a copies of the dataset X will be
written if required (1 file per variable in X). Default is the current working directory, but you
may prefer to use the BaM workspace.}

\item{data.fnames}{Character, data file names.}

\item{fname}{Character, configuration file name.}

\item{doParametric}{Logical, propagate parametric uncertainty?
If FALSE, maxpost parameters are used.}

\item{doStructural}{Logical, propagate structural uncertainty for each output variable? (size nY)}

\item{transposeSpag}{Logical. If FALSE, spaghettis are written horizontally (row-wise), otherwise
they will be transposed so that each spaghetti is a column.}

\item{priorNsim}{Integer, number of samples from the prior distribution for 'prior prediction' experiments.
If negative or NULL (default), posterior samples are used.}

\item{envFiles}{Character vector (size nY, the number of output variables). Name of the files containing the
envelops (e.g. prediction intervals) computed from the spaghettis for each output variable.
By default, same name as spaghetti files but with a '.env' extension.
If NULL, envelops are not computed.}

\item{consoleProgress}{Logical, print progress in BaM.exe console?}

\item{spagFiles_state}{Character vector (size nState, the number of state variables),
same as spagFiles but for states rather than outputs. If NULL, states are not predicted.
Note that only parametric uncertainty is propagated for state variables since they are not observed.
Consequently, structural uncertainty = 0 and total uncertainty = parametric uncertainty.}

\item{transposeSpag_state}{Logical. Same as transposeSpag, but for states rather than outputs.}

\item{envFiles_state}{Character vector (size nState, the number of state variables),
same as envFiles, but for states rather than outputs.}

\item{parSamples}{data frame, parameter samples that will replace the MCMC-generated one for this prediction.}
}
\value{
An object of class 'prediction'.
}
\description{
Creates a new instance of a 'prediction' object
}
\examples{
#--------------
# Example using the twoPopulations dataset, containing 101 values for
# 3 input variables (time t, temperature at site 1 T1, temperature at site 2 T2)
# and 2 output variables (population at site 1 P1, population at site 2 P2).
pred=prediction(X=twoPopulations[,1:3],spagFiles=c('P1.spag','P2.spag'))
#--------------
# Alternative example showing how to propagate uncertainty in some of
# the input variables (here, temperatures T1 and T2)
# Create 100 noisy replicates for T1, representing uncertainty
T1rep=matrix(rnorm(101*100,mean=twoPopulations$T1,sd=0.1),nrow=101,ncol=100)
# Same for T2
T2rep=matrix(rnorm(101*100,mean=twoPopulations$T2,sd=0.1),nrow=101,ncol=100)
# Create prediction object
pred=prediction(X=list(twoPopulations$t,T1rep,T2rep),spagFiles=c('P1.spag','P2.spag'))
}
