% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lfdr.R
\name{Lfdr}
\alias{Lfdr}
\alias{Lfdr.GLVmix}
\alias{Lfdr.WGLVmix}
\alias{Lfdr.GLmix}
\title{Local False Discovery Rate Estimation}
\usage{
Lfdr(G, ...)

\method{Lfdr}{GLVmix}(G, newdata, cnull, tail = "R", ...)

\method{Lfdr}{WGLVmix}(G, newdata, cnull, tail = "R", ...)

\method{Lfdr}{GLmix}(G, newdata, cnull, tail = "R", ...)
}
\arguments{
\item{G}{A fitted object from some G-modeling function.}

\item{...}{other arguments}

\item{newdata}{data frame to in which to evaluate Lfdr}

\item{cnull}{threshold for evaluation of Lfdr}

\item{tail}{either "R" or "L" to specify tail focus}
}
\description{
A Generic function for estimation of Local FDR
}
\details{
Given an estimated mixing distribution, G, Lfdr computes
an estimated local false discovery rate at a specified set
of points and threshold value cnull.  The argument G can be
specified as the fitted object from one of several possible
fitting routines for nonparametric mixing distributions.
}
