% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_delete_vars.R
\name{rd_delete_vars}
\alias{rd_delete_vars}
\title{Delete Variables from REDCap Dataset and Dictionary}
\usage{
rd_delete_vars(
  project = NULL,
  data = NULL,
  dic = NULL,
  event_form = NULL,
  vars = NULL,
  pattern = NULL
)
}
\arguments{
\item{project}{A list containing the REDCap data, dictionary, and event mapping (expected \code{redcap_data()} output). Overrides \code{data}, \code{dic}, and \code{event_form}.}

\item{data}{A \code{data.frame} or \code{tibble} with the REDCap dataset.}

\item{dic}{A \code{data.frame} with the REDCap dictionary.}

\item{event_form}{Only applicable for longitudinal projects (presence of events). Event-to-form mapping for longitudinal projects.}

\item{vars}{Optional. A character vector of variable names to remove from both the dataset and dictionary.}

\item{pattern}{Optional. A character vector of regular expression patterns. Variables matching these patterns will be removed from the dataset and dictionary.}
}
\value{
A list containing:
\describe{
\item{data}{The updated dataset with specified variables removed.}
\item{dictionary}{The updated REDCap dictionary.}
\item{event_form}{The original event-form mapping (if applicable).}
\item{results}{A summary message describing the variable removal operation.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Deletes selected variables from a REDCap dataset and its dictionary, keeping them consistent and preserving variable labels.
}
\details{
\itemize{
\item Ensure that at least one of \code{vars} or \code{pattern} is specified.
\item Removes specified variables and their factor versions (e.g., \code{variable.factor}) from the dataset.
\item Removes matching variables from the dictionary.
\item Warns about factor versions of variables matching patterns, recommending use of \code{rd_factor()} if necessary.
}
}
\examples{
# Delete specific variables by name
result <- rd_delete_vars(
  project = covican,
  vars = c("potassium", "leuk_lymph")
)

# Delete variables matching patterns
result <- rd_delete_vars(
  data = covican$data,
  dic = covican$dictionary,
  pattern = c("_complete$", "_other$")
)

}
