% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_stiefel.R
\name{stiefel.utest}
\alias{stiefel.utest}
\title{Test of Uniformity on Stiefel Manifold}
\usage{
stiefel.utest(stobj, method = c("Rayleigh", "RayleighM"))
}
\arguments{
\item{stobj}{a S3 \code{"riemdata"} class for \eqn{N} Stiefel-valued data.}

\item{method}{(case-insensitive) name of the test method containing \describe{
\item{\code{"Rayleigh"}}{original Rayleigh statistic.}
\item{\code{"RayleighM"}}{modified Rayleigh statistic with better order of error.}
}}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given the data on Stiefel manifold \eqn{St(k,p)}, it tests whether the 
data is distributed uniformly.
}
\examples{
#-------------------------------------------------------------------
#   Compare Rayleigh's original and modified versions of the test
# 
# Test 1. sample uniformly from St(2,4)
# Test 2. use perturbed principal components from 'iris' data in R^4
#         which is concentrated around a point to reject H0.
#-------------------------------------------------------------------
## DATA GENERATION
#  1. uniform data
myobj1 = stiefel.runif(n=100, k=2, p=4)

#  2. perturbed principal components
data(iris)
irdat = list()
for (n in 1:100){
   tmpdata    = iris[1:50,1:4] + matrix(rnorm(50*4,sd=0.5),ncol=4)
   irdat[[n]] = eigen(cov(tmpdata))$vectors[,1:2]
}
myobj2 = wrap.stiefel(irdat)

## TEST
#  1. uniform data
stiefel.utest(myobj1, method="Rayleigh")
stiefel.utest(myobj1, method="RayleighM")

#  2. concentrated data
stiefel.utest(myobj2, method="rayleIgh")   # method names are 
stiefel.utest(myobj2, method="raYleiGhM")  # CASE - INSENSITIVE !

}
\references{
\insertRef{chikuse_statistics_2003}{Riemann}

\insertRef{mardia_directional_1999}{Riemann}
}
\seealso{
\code{\link{wrap.stiefel}}
}
\concept{stiefel}
