% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/property.R
\name{props}
\alias{props}
\alias{props<-}
\alias{set_props}
\title{Get/set multiple properties}
\usage{
props(object, names = prop_names(object))

props(object, check = TRUE) <- value

set_props(object, ..., .check = TRUE)
}
\arguments{
\item{object}{An object from a S7 class}

\item{names}{A character vector of property names to retrieve. Default is all
properties.}

\item{check, .check}{If \code{TRUE}, run \code{\link[=validate]{validate()}} on the object
before returning.}

\item{value}{A named list of values. The object is checked for validity
only after all replacements are performed.}

\item{...}{Name-value pairs given property to modify and new value.}
}
\value{
A named list of property values.
}
\description{
\itemize{
\item \code{props(x)} returns all properties.
\item \code{props(x) <- list(name1 = val1, name2 = val2)} modifies an existing object
by setting multiple properties simultaneously.
\item \code{set_props(x, name1 = val1, name2 = val2)} creates a copy of an existing
object with new values for the specified properties.
}
}
\examples{
Horse <- new_class("Horse", properties = list(
  name = class_character,
  colour = class_character,
  height = class_numeric
))
lexington <- Horse(colour = "bay", height = 15, name = "Lex")

props(lexington)
props(lexington) <- list(height = 14, name = "Lexington")
lexington
}
