% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelstoch_radial_supereff.R
\name{modelstoch_radial_supereff}
\alias{modelstoch_radial_supereff}
\title{Chance Constrained Radial Super-efficiency Models}
\usage{
modelstoch_radial_supereff(datadea,
                                  dmu_eval = NULL,
                                  dmu_ref = NULL,
                                  ...)
}
\arguments{
\item{datadea}{The data of class \code{deadata_stoch} with the expected values
of inputs and outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{...}{Model parameters like \code{orientation} or \code{rts}, and other
parameters to be passed to the solver.}
}
\value{
A list with the results for the evaluated DMUs and other parameters
for reproducibility.
}
\description{
Solve chance constrained radial super-efficiency DEA models, based on the
Cooper et al. (2002) chance constrained radial efficiency models. Analogously to the deterministic case,
it removes the evaluated DMU from the set of reference DMUs \code{dmu_ref}
with respect to which it is evaluated.
}
\note{
Radial super-efficiency chance constrained model under non constant
(vrs, nirs, ndrs, grs) returns to scale can be unfeasible for certain DMUs.
}
\references{
Cooper, W.W.; Deng, H.; Huang, Z.; Li, S.X. (2002). “Chance constrained programming
approaches to technical efficiencies and inefficiencies in stochastic data envelopment
analysis", Journal of the Operational Research Society, 53:12, 1347-1356.
}
\seealso{
\code{\link{modelstoch_radial}}
}
\author{
\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

University of Valencia (Spain)
}
