% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_plot}
\alias{effect_plot}
\alias{print.effect_plot_failure}
\title{One-variable effect plot from an sb_gamlss (or gamlss) fit}
\usage{
effect_plot(fit, var, data, what = "mu", grid = 100)

\method{print}{effect_plot_failure}(x, ...)
}
\arguments{
\item{fit}{sb_gamlss object (or gamlss)}

\item{var}{character, name of the variable to vary}

\item{data}{original data.frame used to fit}

\item{what}{which parameter to predict ("mu","sigma","nu","tau")}

\item{grid}{number of grid points for numeric variable}

\item{x}{object returned by \code{effect_plot()} when prediction fails}

\item{...}{unused}
}
\value{
a ggplot object if ggplot2 present; otherwise draws base plot and returns NULL

Invisibly returns \code{x}.
}
\description{
Varies one variable and holds others at typical values (median/mode) to plot the
predicted parameter curve (default: mu). Uses ggplot2 if available, otherwise base.
}
