% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/failure_probability.R
\name{estimate_failure_probability}
\alias{estimate_failure_probability}
\title{Estimate Failure Probability from Simulator Outputs}
\usage{
estimate_failure_probability(response, threshold, less = TRUE, weights = NULL)
}
\arguments{
\item{response}{Numeric vector of simulator evaluations.}

\item{threshold}{Numeric scalar defining the failure boundary.}

\item{less}{Logical, failure is defined as \code{response <= threshold} when
\code{TRUE} and \code{response >= threshold} otherwise.}

\item{weights}{Optional numeric vector of non-negative weights. The vector is
normalised internally when supplied.}
}
\value{
A list containing the estimated probability and its variance.
}
\description{
Convenient helper to compute the reliability-related probabilities described
in Lebrun et al. (2021). The failure domain is controlled by a threshold and
an inequality direction.
}
\examples{
y <- rnorm(1000)
estimate_failure_probability(y, threshold = -1)
}
