% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunMultiplePlp.R
\name{savePlpAnalysesJson}
\alias{savePlpAnalysesJson}
\title{Save the modelDesignList to a json file}
\usage{
savePlpAnalysesJson(
  modelDesignList = list(createModelDesign(targetId = 1, outcomeId = 2, modelSettings =
    setLassoLogisticRegression()), createModelDesign(targetId = 1, outcomeId = 3,
    modelSettings = setLassoLogisticRegression())),
  cohortDefinitions = NULL,
  saveDirectory = NULL
)
}
\arguments{
\item{modelDesignList}{A list of modelDesigns created using \code{createModelDesign()}}

\item{cohortDefinitions}{A list of the cohortDefinitions (generally extracted from ATLAS)}

\item{saveDirectory}{The directory to save the modelDesignList settings}
}
\value{
The json string of the ModelDesignList
}
\description{
Save the modelDesignList to a json file
}
\details{
This function creates a json file with the modelDesignList saved
}
\examples{
modelDesign <- createModelDesign(targetId = 1, 
                                 outcomeId = 2,
                                 modelSettings = setLassoLogisticRegression())
saveLoc <- file.path(tempdir(), "loadPlpAnalysesJson")
jsonFile <- savePlpAnalysesJson(modelDesignList = modelDesign, saveDirectory = saveLoc)
# clean up
unlink(saveLoc, recursive = TRUE)
}
